/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.transformers;

import com.github.jengelman.gradle.plugins.shadow.tasks.ShadowCopyAction;
import com.github.jengelman.gradle.plugins.shadow.transformers.CacheableTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.ResourceTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.TransformerContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.jetbrains.annotations.NotNull;

@CacheableTransformer
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 !2\u00020\u0001:\u0001!B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\u001c\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\r2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\n\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\f0\u000b8WX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/ManifestAppenderTransformer;", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/ResourceTransformer;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "<init>", "(Lorg/gradle/api/model/ObjectFactory;)V", "getObjectFactory", "()Lorg/gradle/api/model/ObjectFactory;", "manifestContents", "", "attributes", "Lorg/gradle/api/provider/SetProperty;", "Lkotlin/Pair;", "", "", "getAttributes", "()Lorg/gradle/api/provider/SetProperty;", "canTransformResource", "", "element", "Lorg/gradle/api/file/FileTreeElement;", "transform", "", "context", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/TransformerContext;", "hasTransformedResource", "modifyOutputStream", "os", "Lorg/apache/tools/zip/ZipOutputStream;", "preserveFileTimestamps", "append", "name", "value", "Companion", "shadow"})
@SourceDebugExtension(value={"SMAP\nManifestAppenderTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManifestAppenderTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/ManifestAppenderTransformer\n+ 2 GradleCompat.kt\ncom/github/jengelman/gradle/plugins/shadow/internal/GradleCompatKt\n+ 3 Utils.kt\ncom/github/jengelman/gradle/plugins/shadow/internal/UtilsKt\n+ 4 Utils.kt\ncom/github/jengelman/gradle/plugins/shadow/internal/UtilsKt$zipEntry$1\n*L\n1#1,79:1\n68#2,11:80\n36#3,14:91\n50#3:106\n40#4:105\n*S KotlinDebug\n*F\n+ 1 ManifestAppenderTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/ManifestAppenderTransformer\n*L\n31#1:80,11\n52#1:91,14\n52#1:106\n52#1:105\n*E\n"})
public class ManifestAppenderTransformer
implements ResourceTransformer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectFactory objectFactory;
    @NotNull
    private byte[] manifestContents;
    @NotNull
    private final SetProperty<Pair<String, Comparable<?>>> attributes;
    private static final Logger logger = Logging.getLogger(ManifestAppenderTransformer.class);
    @NotNull
    private static final byte[] EOL;
    @NotNull
    private static final byte[] SEPARATOR;

    @Inject
    public ManifestAppenderTransformer(@NotNull ObjectFactory objectFactory) {
        SetProperty setProperty;
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        this.objectFactory = objectFactory;
        this.manifestContents = new byte[0];
        ObjectFactory $this$setProperty_u24default$iv = this.objectFactory;
        Object defaultValue$iv = null;
        boolean $i$f$setProperty = false;
        SetProperty $this$setProperty_u24lambda_u245$iv = setProperty = $this$setProperty_u24default$iv.setProperty(Pair.class);
        boolean bl = false;
        SetProperty setProperty2 = setProperty;
        Intrinsics.checkNotNullExpressionValue((Object)setProperty2, (String)"apply(...)");
        this.attributes = setProperty2;
    }

    @Override
    @NotNull
    public final ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @Input
    @NotNull
    public SetProperty<Pair<String, Comparable<?>>> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean canTransformResource(@NotNull FileTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return StringsKt.equals((String)"META-INF/MANIFEST.MF", (String)element.getPath(), (boolean)true);
    }

    @Override
    public void transform(@NotNull TransformerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.manifestContents.length == 0) {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ByteStreamsKt.copyTo$default((InputStream)context.getInputStream(), (OutputStream)outputStream, (int)0, (int)2, null);
                byte[] byArray = outputStream.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                this.manifestContents = byArray;
            }
            catch (IOException e) {
                logger.warn("Failed to read MANIFEST.MF", (Throwable)e);
            }
        }
    }

    @Override
    public boolean hasTransformedResource() {
        Object object = this.getAttributes().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return !((Collection)object).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void modifyOutputStream(@NotNull ZipOutputStream os, boolean preserveFileTimestamps) {
        void name$iv;
        ZipEntry zipEntry2;
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        String string = "META-INF/MANIFEST.MF";
        boolean preserveLastModified$iv = preserveFileTimestamps;
        long lastModified$iv = -1L;
        boolean $i$f$zipEntry = false;
        ZipEntry $this$zipEntry_u24lambda_u240$iv = zipEntry2 = new ZipEntry((String)name$iv);
        boolean bl = false;
        if (preserveLastModified$iv) {
            if (lastModified$iv >= 0L) {
                $this$zipEntry_u24lambda_u240$iv.setTime(lastModified$iv);
            }
        } else {
            $this$zipEntry_u24lambda_u240$iv.setTime(ShadowCopyAction.Companion.getCONSTANT_TIME_FOR_ZIP_ENTRIES());
        }
        ZipEntry zipEntry3 = $this$zipEntry_u24lambda_u240$iv;
        ZipOutputStream zipOutputStream = os;
        boolean bl2 = false;
        ZipEntry zipEntry4 = zipEntry3;
        zipOutputStream.putNextEntry(zipEntry2);
        os.write(this.manifestContents);
        Object object = this.getAttributes().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (!((Collection)object).isEmpty()) {
            for (Pair pair : (Set)this.getAttributes().get()) {
                String key = (String)pair.component1();
                Comparable value = (Comparable)pair.component2();
                String string2 = key;
                byte[] byArray = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                os.write(byArray);
                os.write(SEPARATOR);
                string2 = value.toString();
                byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                os.write(byArray2);
                os.write(EOL);
            }
            os.write(EOL);
            this.getAttributes().empty();
        }
        os.closeEntry();
    }

    public void append(@NotNull String name, @NotNull Comparable<?> value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.getAttributes().add((Object)TuplesKt.to((Object)name, value));
    }

    static {
        String string = "\r\n";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        EOL = byArray;
        string = ": ";
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        SEPARATOR = byArray2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/ManifestAppenderTransformer$Companion;", "", "<init>", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "EOL", "", "SEPARATOR", "shadow"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

