/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.relocation;

import com.github.jengelman.gradle.plugins.shadow.relocation.CacheableRelocator;
import com.github.jengelman.gradle.plugins.shadow.relocation.RelocateClassContext;
import com.github.jengelman.gradle.plugins.shadow.relocation.RelocatePathContext;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.codehaus.plexus.util.SelectorUtils;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

@CacheableRelocator
public class SimpleRelocator
implements Relocator,
GroovyObject {
    private final String pattern;
    private final String pathPattern;
    private final String shadedPattern;
    private final String shadedPathPattern;
    private final Set<String> includes;
    private final Set<String> excludes;
    private final boolean rawString;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public SimpleRelocator() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public SimpleRelocator(String patt, String shadedPattern, List<String> includes, List<String> excludes) {
        this(patt, shadedPattern, includes, excludes, false);
    }

    public SimpleRelocator(String patt, String shadedPattern, List<String> includes, List<String> excludes, boolean rawString) {
        boolean bl;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.rawString = bl = rawString;
        if (rawString) {
            String string;
            String string2;
            this.pathPattern = string2 = patt;
            this.shadedPathPattern = string = shadedPattern;
            Object var10_10 = null;
            this.pattern = IndyInterface.bootstrap("cast", "()", 0, var10_10);
            Object var11_11 = null;
            this.shadedPattern = IndyInterface.bootstrap("cast", "()", 0, var11_11);
        } else {
            if (ScriptBytecodeAdapter.compareEqual((Object)patt, null)) {
                String string;
                String string3;
                this.pattern = string3 = "";
                this.pathPattern = string = "";
            } else {
                CallSite callSite = IndyInterface.bootstrap("invoke", "replace", 0, patt, "/", ".");
                this.pattern = IndyInterface.bootstrap("cast", "()", 0, callSite);
                CallSite callSite2 = IndyInterface.bootstrap("invoke", "replace", 0, patt, ".", "/");
                this.pathPattern = IndyInterface.bootstrap("cast", "()", 0, callSite2);
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)shadedPattern, null)) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "replace", 0, shadedPattern, "/", ".");
                this.shadedPattern = IndyInterface.bootstrap("cast", "()", 0, callSite);
                CallSite callSite3 = IndyInterface.bootstrap("invoke", "replace", 0, shadedPattern, ".", "/");
                this.shadedPathPattern = IndyInterface.bootstrap("cast", "()", 0, callSite3);
            } else {
                CallSite callSite = IndyInterface.bootstrap("invoke", "plus", 0, "hidden.", this.pattern);
                this.shadedPattern = IndyInterface.bootstrap("cast", "()", 0, callSite);
                CallSite callSite4 = IndyInterface.bootstrap("invoke", "plus", 0, "hidden/", this.pathPattern);
                this.shadedPathPattern = IndyInterface.bootstrap("cast", "()", 0, callSite4);
            }
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "normalizePatterns", 0, SimpleRelocator.class, includes);
        this.includes = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite5 = IndyInterface.bootstrap("invoke", "normalizePatterns", 0, SimpleRelocator.class, excludes);
        this.excludes = IndyInterface.bootstrap("cast", "()", 0, callSite5);
    }

    public SimpleRelocator include(String pattern) {
        IndyInterface.bootstrap("invoke", "addAll", 0, this.includes, IndyInterface.bootstrap("invoke", "normalizePatterns", 0, SimpleRelocator.class, ScriptBytecodeAdapter.createList((Object[])new Object[]{pattern})));
        return this;
    }

    public SimpleRelocator exclude(String pattern) {
        IndyInterface.bootstrap("invoke", "addAll", 0, this.excludes, IndyInterface.bootstrap("invoke", "normalizePatterns", 0, SimpleRelocator.class, ScriptBytecodeAdapter.createList((Object[])new Object[]{pattern})));
        return this;
    }

    private static Set<String> normalizePatterns(Collection<String> patterns) {
        CallSite callSite;
        CallSite normalized = null;
        if (ScriptBytecodeAdapter.compareNotEqual(patterns, null) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, patterns)) == false) {
            normalized = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, LinkedHashSet.class));
            CallSite pattern = null;
            CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, patterns));
            if (callSite2 != null) {
                while (callSite2.hasNext()) {
                    pattern = IndyInterface.bootstrap("cast", "()", 0, callSite2.next());
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "startsWith", 0, pattern, IndyInterface.bootstrap("getProperty", "REGEX_HANDLER_PREFIX", 0, SelectorUtils.class))) != false) {
                        IndyInterface.bootstrap("invoke", "add", 0, normalized, pattern);
                        continue;
                    }
                    CallSite classPattern = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replace", 0, pattern, ".", "/"));
                    IndyInterface.bootstrap("invoke", "add", 0, normalized, classPattern);
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "endsWith", 0, classPattern, "/*")) == false) continue;
                    CallSite packagePattern = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, classPattern, false, IndyInterface.bootstrap("invoke", "lastIndexOf", 0, classPattern, "/")));
                    IndyInterface.bootstrap("invoke", "add", 0, normalized, packagePattern);
                }
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite = normalized) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
    }

    private boolean isIncluded(String path) {
        if (ScriptBytecodeAdapter.compareNotEqual(this.includes, null) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, this.includes)) == false) {
            CallSite include = null;
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, this.includes));
            if (callSite != null) {
                while (callSite.hasNext()) {
                    include = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matchPath", 0, SelectorUtils.class, include, path, "/", true)) == false) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean isExcluded(String path) {
        if (ScriptBytecodeAdapter.compareNotEqual(this.excludes, null) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, this.excludes)) == false) {
            CallSite exclude = null;
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, this.excludes));
            if (callSite != null) {
                while (callSite.hasNext()) {
                    exclude = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matchPath", 0, SelectorUtils.class, exclude, path, "/", true)) == false) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean canRelocatePath(String path) {
        if (this.rawString) {
            return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("invoke", "matcher", 0, IndyInterface.bootstrap("invoke", "compile", 0, Pattern.class, this.pathPattern), path)));
        }
        if (ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("invoke", "length", 0, path), (Object)IndyInterface.bootstrap("invoke", "length", 0, this.pathPattern))) {
            return false;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "endsWith", 0, path, ".class")) != false) {
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "length", 0, path), (Object)6)) {
                return false;
            }
            path = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, path, false, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "length", 0, path), 6)));
        }
        boolean pathStartsWithPattern = DefaultTypeTransformation.booleanUnbox((Object)(ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "charAt", 0, path, false), (Object)"/") ? IndyInterface.bootstrap("invoke", "startsWith", 0, path, this.pathPattern, true) : IndyInterface.bootstrap("invoke", "startsWith", 0, path, this.pathPattern)));
        if (pathStartsWithPattern) {
            return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isIncluded", 2, this, path)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isExcluded", 2, this, path)) == false;
        }
        return false;
    }

    @Override
    public boolean canRelocateClass(String className) {
        return !this.rawString && ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("invoke", "indexOf", 0, className, "/"), (Object)0) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "canRelocatePath", 2, this, IndyInterface.bootstrap("invoke", "replace", 0, className, ".", "/")));
    }

    @Override
    public String relocatePath(RelocatePathContext context) {
        CallSite path = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "path", 4, context));
        IndyInterface.bootstrap("invoke", "relocate", 0, IndyInterface.bootstrap("getProperty", "stats", 4, context), this.pathPattern, this.shadedPathPattern);
        if (this.rawString) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, path, this.pathPattern, this.shadedPathPattern));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replaceFirst", 0, path, this.pathPattern, this.shadedPathPattern));
    }

    @Override
    public String relocateClass(RelocateClassContext context) {
        CallSite clazz = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "className", 4, context));
        IndyInterface.bootstrap("invoke", "relocate", 0, IndyInterface.bootstrap("getProperty", "stats", 4, context), this.pathPattern, this.shadedPathPattern);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replaceFirst", 0, clazz, this.pattern, this.shadedPattern));
    }

    @Override
    public String applyToSourceContent(String sourceContent) {
        if (this.rawString) {
            return sourceContent;
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, sourceContent, IndyInterface.bootstrap("invoke", "plus", 0, "\\b", this.pattern), this.shadedPattern));
    }

    @Input
    @Optional
    public String getPattern() {
        return this.pattern;
    }

    @Input
    public String getPathPattern() {
        return this.pathPattern;
    }

    @Input
    @Optional
    public String getShadedPattern() {
        return this.shadedPattern;
    }

    @Input
    public String getShadedPathPattern() {
        return this.shadedPathPattern;
    }

    @Input
    public Set<String> getIncludes() {
        return this.includes;
    }

    @Input
    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Input
    public boolean getRawString() {
        return this.rawString;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SimpleRelocator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

