/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.maven.internal.xml;

import java.io.Writer;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import shadow.com.ctc.wstx.stax.WstxOutputFactory;
import shadow.org.apache.maven.api.xml.XmlNode;
import shadow.org.codehaus.stax2.util.StreamWriterDelegate;

public class XmlNodeWriter {
    public static void write(Writer writer, XmlNode dom) throws XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        ((XMLOutputFactory)factory).setProperty("javax.xml.stream.isRepairingNamespaces", false);
        ((XMLOutputFactory)factory).setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
        ((XMLOutputFactory)factory).setProperty("com.ctc.wstx.addSpaceAfterEmptyElem", true);
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(((XMLOutputFactory)factory).createXMLStreamWriter(writer));
        XmlNodeWriter.write(serializer, dom);
        serializer.close();
    }

    public static void write(XMLStreamWriter xmlWriter, XmlNode dom) throws XMLStreamException {
        xmlWriter.writeStartElement(dom.getPrefix(), dom.getName(), dom.getNamespaceUri());
        for (Map.Entry<String, String> attr : dom.getAttributes().entrySet()) {
            xmlWriter.writeAttribute(attr.getKey(), attr.getValue());
        }
        for (XmlNode aChildren : dom.getChildren()) {
            XmlNodeWriter.write(xmlWriter, aChildren);
        }
        String value = dom.getValue();
        if (value != null) {
            xmlWriter.writeCharacters(value);
        }
        xmlWriter.writeEndElement();
    }

    static class IndentingXMLStreamWriter
    extends StreamWriterDelegate {
        int depth = 0;
        boolean hasChildren = false;
        boolean anew = true;

        IndentingXMLStreamWriter(XMLStreamWriter parent) {
            super(parent);
        }

        @Override
        public void writeStartDocument() throws XMLStreamException {
            super.writeStartDocument();
            this.anew = false;
        }

        @Override
        public void writeStartDocument(String version) throws XMLStreamException {
            super.writeStartDocument(version);
            this.anew = false;
        }

        @Override
        public void writeStartDocument(String encoding, String version) throws XMLStreamException {
            super.writeStartDocument(encoding, version);
            this.anew = false;
        }

        @Override
        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(localName);
            this.hasChildren = true;
            this.anew = false;
        }

        @Override
        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(namespaceURI, localName);
            this.hasChildren = true;
            this.anew = false;
        }

        @Override
        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(prefix, localName, namespaceURI);
            this.hasChildren = true;
            this.anew = false;
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.indent();
            super.writeStartElement(localName);
            ++this.depth;
            this.hasChildren = false;
            this.anew = false;
        }

        @Override
        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            super.writeStartElement(namespaceURI, localName);
            ++this.depth;
            this.hasChildren = false;
            this.anew = false;
        }

        @Override
        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            super.writeStartElement(prefix, localName, namespaceURI);
            ++this.depth;
            this.hasChildren = false;
            this.anew = false;
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            --this.depth;
            if (this.hasChildren) {
                this.indent();
            }
            super.writeEndElement();
            this.hasChildren = true;
            this.anew = false;
        }

        private void indent() throws XMLStreamException {
            if (!this.anew) {
                super.writeCharacters("\n");
            }
            for (int i = 0; i < this.depth; ++i) {
                super.writeCharacters("  ");
            }
        }
    }
}

