/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish.protocols.v1.models.publish;

import java.util.HashSet;
import java.util.Set;

public class ArtifactTypeCodec {
    private static final Set<String> allowedExtensions = new HashSet<String>();

    public static String encode(String extension, String classifier) {
        ArtifactTypeCodec.validateExtension(extension);
        if (classifier != null) {
            return extension + ":" + classifier;
        }
        return extension;
    }

    public static ArtifactType decode(String encoded) {
        switch (encoded.toUpperCase()) {
            case "JAR": {
                return new ArtifactType("jar", null);
            }
            case "POM": {
                return new ArtifactType("pom", null);
            }
            case "SIGNATURE_JAR": {
                return new ArtifactType("jar.asc", null);
            }
            case "SIGNATURE_POM": {
                return new ArtifactType("pom.asc", null);
            }
            case "SIGNATURE_SOURCES": {
                return new ArtifactType("jar.asc", "sources");
            }
            case "SIGNATURE_JAVADOC": {
                return new ArtifactType("jar.asc", "javadoc");
            }
            case "SIGNATURE_GROOVYDOC": {
                return new ArtifactType("jar.asc", "groovydoc");
            }
            case "SOURCES": {
                return new ArtifactType("jar", "sources");
            }
            case "JAVADOC": {
                return new ArtifactType("jar", "javadoc");
            }
            case "GROOVYDOC": {
                return new ArtifactType("jar", "groovydoc");
            }
        }
        String[] split = encoded.split(":");
        ArtifactTypeCodec.validateExtension(split[0]);
        if (split.length == 2) {
            return new ArtifactType(split[0], split[1]);
        }
        return new ArtifactType(split[0], null);
    }

    private static void validateExtension(String extension) {
        if (!allowedExtensions.contains(extension)) {
            throw new IllegalArgumentException("Unsupported extension: " + extension);
        }
    }

    static {
        allowedExtensions.add("pom");
        allowedExtensions.add("module");
        allowedExtensions.add("jar");
        allowedExtensions.add("pom.asc");
        allowedExtensions.add("module.asc");
        allowedExtensions.add("jar.asc");
        allowedExtensions.add("pom.sigstore");
        allowedExtensions.add("module.sigstore");
        allowedExtensions.add("jar.sigstore");
    }

    public static class ArtifactType {
        public final String extension;
        public final String classifier;

        public ArtifactType(String extension, String classifier) {
            this.extension = extension;
            this.classifier = classifier;
        }
    }
}

