/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.AbstractConfigValidator;
import com.gradle.publish.PluginBundleExtension;
import com.gradle.publish.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;

public class LegacyConfigValidator
extends AbstractConfigValidator {
    private final PluginBundleExtension bundleConfig;

    public LegacyConfigValidator(PluginBundleExtension bundleConfig, boolean skipNamespaceCheck) {
        super(skipNamespaceCheck);
        this.bundleConfig = bundleConfig;
    }

    @Override
    public void validateConfig(GradlePluginDevelopmentExtension pluginConfig) {
        if (pluginConfig.getPlugins().isEmpty()) {
            throw new IllegalArgumentException("No plugins defined. Please declare at least one plugin in a 'gradlePlugin.plugins' block");
        }
        this.validateURLs(this.bundleConfig.getWebsite(), this.bundleConfig.getVcsUrl());
        this.validatePluginIdUniqueness(pluginConfig);
        this.validatePluginTagKeys(pluginConfig);
        for (PluginDeclaration plugin : pluginConfig.getPlugins()) {
            this.validatePluginConfig(plugin);
        }
    }

    @Override
    public void validatePluginConfig(PluginDeclaration plugin) {
        String pluginName = plugin.getName();
        this.validatePluginId(pluginName, plugin.getId());
        this.validateDisplayName(pluginName, plugin.getDisplayName());
        this.validateDescription(pluginName, plugin.getDescription() == null ? this.bundleConfig.getDescription() : plugin.getDescription());
        this.validateImplementationClass(pluginName, plugin.getImplementationClass());
        this.validateTags(plugin);
    }

    @Override
    public void validateTags(PluginDeclaration plugin) {
        String pluginName = plugin.getName();
        Collection<String> tags = Util.getTags(this.bundleConfig, pluginName);
        this.validateTags(pluginName, tags);
    }

    private void validatePluginTagKeys(GradlePluginDevelopmentExtension extension) {
        HashSet<String> plugins = new HashSet<String>(this.bundleConfig.getPluginTags().keySet());
        plugins.removeAll(extension.getPlugins().getNames());
        if (!plugins.isEmpty()) {
            ArrayList<String> sortedPlugins = new ArrayList<String>(plugins);
            sortedPlugins.sort(String::compareTo);
            throw new IllegalArgumentException("Tags set for undefined plugin(s): " + String.join((CharSequence)", ", sortedPlugins));
        }
    }
}

