package com.gradle.publish;

import com.gradle.publish.protocols.v1.models.ClientRequest;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URL;
import java.util.Collection;

public class Util {
    public static boolean isBlank(String src) {
        return src == null || src.trim().isEmpty();
    }

    public static String toHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        return String.format("%0" + (bytes.length << 1) + "X", bi);
    }

    public static <Resp, Req extends ClientRequest<Resp>> Resp convertResponse(
        Req request,
        URL url,
        String response,
        int statusCode
    ) {
        return convertResponse(request, url.toExternalForm(), response, statusCode);
    }

    public static <Resp, Req extends ClientRequest<Resp>> Resp convertResponse(
        Req request,
        String url,
        String response,
        int statusCode
    ) {
        try {
            return request.convertResponse(response);
        } catch (Exception e) {
            // probably wrong url
            throw new RuntimeException("Error communicating with server.\n"
                + "URL " + url + " returned response code " + statusCode);
        }
    }

    static Collection<String> getTags(PluginBundleExtension bundleConfig, String pluginName) {
        Collection<String> tags = bundleConfig.getPluginTags().get(pluginName);
        if (tags != null && !tags.isEmpty()) {
            return tags;
        }

        return bundleConfig.getTags();
    }

    public static String getWebsite(GradlePluginDevelopmentExtension extension) {
        Property<String> property = call("getWebsite", GradlePluginDevelopmentExtension.class, extension);
        return property.getOrNull();
    }

    public static String getVcsUrl(GradlePluginDevelopmentExtension extension) {
        Property<String> property = call("getVcsUrl", GradlePluginDevelopmentExtension.class, extension);
        return property.getOrNull();
    }

    public static Collection<String> getTags(PluginDeclaration plugin) {
        SetProperty<String> tagsProperty = call("getTags", PluginDeclaration.class, plugin);
        return tagsProperty.get();
    }

    private static <T> T call(String methodName, Class type, Object object) {
        try {
            Method method = type.getMethod(methodName);
            return (T) method.invoke(object);
        } catch (NoSuchMethodException e) {
            throw new RuntimeException("Method '" + methodName + "' doesn't exist in '" + type.getSimpleName() + "'");
        } catch (IllegalAccessException e) {
            throw new RuntimeException("Method '" + methodName + "' is inaccessible in '" + type.getSimpleName() + "'");
        } catch (InvocationTargetException e) {
            throw new RuntimeException("Method '" + methodName + "' from '" + type.getSimpleName() + "' has thrown an exception: " + e.getCause().getMessage());
        }
    }
}
