package com.gradle.publish;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

import static com.gradle.publish.Util.toHex;

/** Adapted from Adept Hasher with permission (REMOVE THIS FILE AND REPLACE) */
public class Hasher {

    static ThreadLocal<MessageDigest> md = new ThreadLocal<MessageDigest>() {
        @Override
        public MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("SHA-256");
            } catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    };

    public static String hash(byte[] bytes) {
        MessageDigest currentMd = md.get();
        currentMd.reset();
        try {
            currentMd.update(bytes);
            return toHex(currentMd.digest()).toLowerCase();
        } finally {
            currentMd.reset();
        }
    }

    public static String hash(InputStream is) throws IOException {
        MessageDigest currentMd = md.get();
        currentMd.reset();
        try {
            byte[] buf = new byte[1024 * 4]; // _seemed_ to be the fastest
            int len = is.read(buf);

            while (len > 0) {
                currentMd.update(buf, 0, len);
                len = is.read(buf);
            }
            return toHex(currentMd.digest()).toLowerCase();
        } finally {
            currentMd.reset();
        }
    }

}
