/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.AbstractConfigValidator;
import com.gradle.publish.ConfigValidator;
import com.gradle.publish.Hasher;
import com.gradle.publish.LegacyConfigValidator;
import com.gradle.publish.PluginBundleExtension;
import com.gradle.publish.PortalPublisher;
import com.gradle.publish.Util;
import com.gradle.publish.protocols.v1.models.publish.ArtifactTypeCodec;
import com.gradle.publish.protocols.v1.models.publish.BuildMetadata;
import com.gradle.publish.protocols.v1.models.publish.PublishArtifact;
import com.gradle.publish.protocols.v1.models.publish.PublishMavenCoordinates;
import com.gradle.publish.protocols.v1.models.publish.PublishNewVersionRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.util.GradleVersion;

public class PublishTask
extends DefaultTask {
    public static final String GRADLE_PUBLISH_SECRET = "gradle.publish.secret";
    public static final String GRADLE_PUBLISH_KEY = "gradle.publish.key";
    public static final String GRADLE_PUBLISH_SECRET_ENV = "GRADLE_PUBLISH_SECRET";
    public static final String GRADLE_PUBLISH_KEY_ENV = "GRADLE_PUBLISH_KEY";
    private static final String SKIP_NAMESPACE_CHECK_PROPERTY = "gradle.publish.skip.namespace.check";
    private static final String MAVEN_PUBLISH_POM_TASK_NAME = "generatePomFileForPluginMavenPublication";
    private static final String MAVEN_PUBLISH_GMM_TASK_NAME = "generateMetadataFileForPluginMavenPublication";
    static final String MAVEN_PUBLICATION_NAME = "pluginMaven";
    static final String MARKER_PUBLICATION_SUFFIX = "PluginMarkerMaven";
    private static final Logger LOGGER = Logging.getLogger(PublishTask.class);
    private final PortalPublisher portalPublisher = new PortalPublisher(this.getProject());
    private PluginBundleExtension bundleConfig;
    private boolean useLegacyConfig;
    private GradlePluginDevelopmentExtension pluginConfig;
    private AbstractConfigValidator validator;

    @TaskAction
    void publish() throws Exception {
        this.useLegacyConfig = this.useLegacyConfig();
        boolean skipNamespaceCheck = System.getProperty(SKIP_NAMESPACE_CHECK_PROPERTY, "false").equals("true");
        this.validator = this.useLegacyConfig ? new LegacyConfigValidator(this.bundleConfig, skipNamespaceCheck) : new ConfigValidator(skipNamespaceCheck);
        this.pluginConfig = (GradlePluginDevelopmentExtension)this.getProject().getExtensions().getByType(GradlePluginDevelopmentExtension.class);
        this.validator.validateConfig(this.pluginConfig);
        PublishMavenCoordinates mavenCoords = this.ensurePomIsAvailable();
        this.validateVersion(mavenCoords.getVersion());
        List<PublishNewVersionRequest> requests = this.buildPublishRequests(mavenCoords);
        this.validatePluginDescriptors(requests);
        Map<PublishArtifact, File> artifacts = this.collectArtifacts();
        this.portalPublisher.publishToPortal(requests, mavenCoords, artifacts);
    }

    private boolean useLegacyConfig() {
        if (PublishTask.runningOnPreGradle("7.6-dev-1")) {
            return true;
        }
        if (!PublishTask.runningOnPreGradle("8.0-dev-1")) {
            return false;
        }
        if (!this.bundleConfig.isEmpty()) {
            DeprecationLogger.deprecate((String)"Using the `pluginBundle` block to configure plugin publication").withAdvice("Use new properties of `gradlePlugin` instead.").willBeRemovedInGradle8().withUserManual("publishing_gradle_plugins", "sec:configuring-publish-plugin").nagUser();
            return true;
        }
        return false;
    }

    private void validatePluginDescriptors(List<PublishNewVersionRequest> requests) {
        File artifactFile = this.findMainArtifact();
        try (ZipFile zip = new ZipFile(artifactFile);){
            for (PublishNewVersionRequest request : requests) {
                this.validatePluginDescriptor(zip, request.getPluginId());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to validate plugin jar " + artifactFile.getPath(), e);
        }
    }

    private void validateVersion(String version) {
        String regExp = "[a-zA-Z0-9\\-\\.\\[\\]\\:\\+]*";
        String numberRegExp = ".*?[0-9].*?";
        if (Util.isBlank(version) || version.equals("unspecified")) {
            throw new IllegalArgumentException("Please set the project version");
        }
        if (!version.matches(numberRegExp) || !version.matches(regExp) || version.length() > 50) {
            throw new RuntimeException("Invalid version '" + version + "'. Project version string must: 1) not be empty and less than 50 characters long; 2) include a number; 3) match the regular expression: " + regExp);
        }
        if (version.trim().endsWith("-SNAPSHOT")) {
            throw new IllegalArgumentException("-SNAPSHOT plugin versions not supported, please use a fixed version instead.");
        }
    }

    private void validatePluginDescriptor(ZipFile zip, String pluginId) throws IOException {
        String resPath = String.format("META-INF/gradle-plugins/%s.properties", pluginId);
        ZipEntry descriptorEntry = zip.getEntry(resPath);
        if (descriptorEntry == null) {
            throw new IllegalArgumentException(String.format("No plugin descriptor for plugin ID '%s'.\nCreate a 'META-INF/gradle-plugins/%s.properties' file with a 'implementation-class' property pointing to the plugin class implementation.", pluginId, pluginId));
        }
        Properties descriptor = new Properties();
        descriptor.load(zip.getInputStream(descriptorEntry));
        String pluginClassName = descriptor.getProperty("implementation-class");
        if (Util.isBlank(pluginClassName)) {
            throw new IllegalArgumentException(String.format("Plugin descriptor for plugin ID '%s' does not specify a plugin\nclass with the implementation-class property", pluginId));
        }
        String pluginClassResourcePath = pluginClassName.replace('.', '/').concat(".class");
        if (zip.getEntry(pluginClassResourcePath) == null) {
            throw new IllegalArgumentException(String.format("Plugin descriptor for plugin ID '%s' specifies a plugin\nclass '%s' that is not present in the jar file", pluginId, pluginClassName));
        }
    }

    private PublishMavenCoordinates ensurePomIsAvailable() {
        GenerateMavenPom pomTask = (GenerateMavenPom)this.getProject().getTasks().getByName(MAVEN_PUBLISH_POM_TASK_NAME);
        File pomFile = pomTask.getDestination();
        if (!pomFile.exists()) {
            throw new MissingResourceException(pomFile.toURI(), "Could not use POM from generatePomFileForPluginMavenPublication task because it does not exist");
        }
        PublishingExtension publishing = (PublishingExtension)this.getProject().getExtensions().getByType(PublishingExtension.class);
        MavenPublication pluginPublication = (MavenPublication)publishing.getPublications().getByName(MAVEN_PUBLICATION_NAME);
        return this.validateMavenCoordinates(pluginPublication.getGroupId(), pluginPublication.getArtifactId(), pluginPublication.getVersion());
    }

    void addAndHashArtifact(Map<PublishArtifact, File> artifacts, File file, String type, String classifier) throws IOException {
        if (file != null && file.exists()) {
            try (FileInputStream fis = new FileInputStream(file);){
                String hash = Hasher.hash(fis);
                try {
                    String artifactType = ArtifactTypeCodec.encode(type, classifier);
                    artifacts.put(new PublishArtifact(artifactType, hash), file);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Ignoring unknown artifact with type \"{}\" and classifier \"{}\".\nYou can only upload normal jars, sources jars, javadoc jars and groovydoc jars\nwith or without signatures to the Plugin Portal at this time.", (Object)type, (Object)classifier);
                }
            }
        }
    }

    private Map<PublishArtifact, File> collectArtifacts() throws IOException {
        LinkedHashMap<PublishArtifact, File> artifacts = new LinkedHashMap<PublishArtifact, File>();
        for (MavenArtifact mavenArtifact : this.getNormalizedMavenPublication().getAllArtifacts()) {
            this.addAndHashArtifact(artifacts, mavenArtifact.getFile(), mavenArtifact.getExtension(), mavenArtifact.getClassifier());
        }
        return artifacts;
    }

    private File findMainArtifact() {
        MavenNormalizedPublication publication = this.getNormalizedMavenPublication();
        if (this.isMainArtifact(publication.getMainArtifact())) {
            return publication.getMainArtifact().getFile();
        }
        Set artifacts = publication.getAllArtifacts();
        Optional<MavenArtifact> artifact = artifacts.stream().filter(this::isMainArtifact).findFirst();
        if (artifact.isPresent()) {
            return artifact.get().getFile();
        }
        throw new IllegalArgumentException("Cannot determine main artifact to upload - could not find jar artifact with empty classifier");
    }

    private boolean isMainArtifact(MavenArtifact artifact) {
        if (artifact == null) {
            return false;
        }
        if (!"jar".equals(artifact.getExtension())) {
            return false;
        }
        return Util.isBlank(artifact.getClassifier());
    }

    private MavenNormalizedPublication getNormalizedMavenPublication() {
        PublishingExtension publishingExtension = (PublishingExtension)this.getProject().getExtensions().getByType(PublishingExtension.class);
        PublicationInternal publication = (PublicationInternal)publishingExtension.getPublications().getByName(MAVEN_PUBLICATION_NAME);
        MavenNormalizedPublication normalizedPublication = ((DefaultMavenPublication)publication).asNormalisedPublication();
        return normalizedPublication;
    }

    private PublishMavenCoordinates validateMavenCoordinates(String groupId, String artifactId, String version) {
        this.validator.validateMavenCoordinates(groupId, artifactId, version);
        return new PublishMavenCoordinates(groupId, artifactId, version);
    }

    private List<PublishNewVersionRequest> buildPublishRequests(PublishMavenCoordinates mavenCoords) {
        String website = this.useLegacyConfig ? this.bundleConfig.getWebsite() : Util.getWebsite(this.pluginConfig);
        String vcsUrl = this.useLegacyConfig ? this.bundleConfig.getVcsUrl() : Util.getVcsUrl(this.pluginConfig);
        ArrayList<PublishNewVersionRequest> reqs = new ArrayList<PublishNewVersionRequest>();
        for (PluginDeclaration plugin : this.pluginConfig.getPlugins()) {
            reqs.add(this.buildPublishRequest(mavenCoords, website, vcsUrl, plugin));
        }
        return reqs;
    }

    private List<String> getTags(PluginDeclaration pluginDeclaration) {
        Collection<String> tags = this.useLegacyConfig ? Util.getTags(this.bundleConfig, pluginDeclaration.getName()) : Util.getTags(pluginDeclaration);
        return tags.stream().map(String::toLowerCase).distinct().collect(Collectors.toList());
    }

    private PublishNewVersionRequest buildPublishRequest(PublishMavenCoordinates mavenCoords, String website, String vcsUrl, PluginDeclaration plugin) {
        PublishNewVersionRequest request = new PublishNewVersionRequest();
        BuildMetadata buildMetadata = new BuildMetadata(this.getProject().getGradle().getGradleVersion());
        request.setBuildMetadata(buildMetadata);
        request.setPluginId(plugin.getId());
        request.setPluginVersion(mavenCoords.getVersion());
        request.setDisplayName(plugin.getDisplayName());
        String desc = plugin.getDescription();
        desc = desc == null && this.useLegacyConfig ? this.bundleConfig.getDescription() : desc;
        request.setDescription(desc);
        request.setTags(this.getTags(plugin));
        request.setWebSite(website);
        request.setVcsUrl(vcsUrl);
        return request;
    }

    public void setBundleConfig(PluginBundleExtension bundleConfig) {
        this.bundleConfig = bundleConfig;
    }

    public void afterProjectEvaluate() {
        Project project = this.getProject();
        this.dependsOn(new Object[]{project.getTasks().matching(task -> MAVEN_PUBLISH_POM_TASK_NAME.equals(task.getName()))});
        GenerateModuleMetadata gmmTask = (GenerateModuleMetadata)project.getTasks().findByName(MAVEN_PUBLISH_GMM_TASK_NAME);
        if (gmmTask != null && gmmTask.getEnabled()) {
            this.dependsOn(new Object[]{gmmTask.getOutputFile()});
        }
        project.getPluginManager().withPlugin("signing", signingPlugin -> {
            LOGGER.lifecycle("Signing plugin detected. Will automatically sign the published artifacts.");
            SigningExtension signing = (SigningExtension)project.getExtensions().getByType(SigningExtension.class);
            PublishingExtension publishing = (PublishingExtension)this.getProject().getExtensions().getByType(PublishingExtension.class);
            this.wireInSigningTask(project, signing, (Publication)publishing.getPublications().getByName(MAVEN_PUBLICATION_NAME));
            NamedDomainObjectContainer plugins = ((GradlePluginDevelopmentExtension)this.getProject().getExtensions().getByType(GradlePluginDevelopmentExtension.class)).getPlugins();
            for (PluginDeclaration plugin : plugins) {
                String markerPublicationName = plugin.getName() + MARKER_PUBLICATION_SUFFIX;
                Publication publication = (Publication)publishing.getPublications().getByName(markerPublicationName);
                this.wireInSigningTask(project, signing, publication);
            }
        });
    }

    private void wireInSigningTask(Project project, SigningExtension signing, Publication publication) {
        String signTaskName = PublishTask.determineSignTaskNameForPublication(publication);
        Task signTask = (Task)project.getTasks().findByName(signTaskName);
        if (signTask == null) {
            signTask = (Task)signing.sign(new Publication[]{publication}).get(0);
        }
        this.dependsOn(new Object[]{signTask});
    }

    private static boolean runningOnPreGradle(String version) {
        return GradleVersion.current().compareTo(GradleVersion.version((String)version)) < 0;
    }

    private static String determineSignTaskNameForPublication(Publication publication) {
        return "sign" + StringGroovyMethods.capitalize((CharSequence)publication.getName()) + "Publication";
    }
}

