/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.AbstractConfigValidator;
import com.gradle.publish.Util;
import java.util.Collection;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;

public class ConfigValidator
extends AbstractConfigValidator {
    public ConfigValidator(boolean skipNamespaceCheck) {
        super(skipNamespaceCheck);
    }

    @Override
    public void validateConfig(GradlePluginDevelopmentExtension extension) {
        if (extension.getPlugins().isEmpty()) {
            throw new IllegalArgumentException("No plugins defined. Please declare at least one plugin in a 'gradlePlugin.plugins' block");
        }
        this.validateURLs(Util.getWebsite(extension), Util.getVcsUrl(extension));
        this.validatePluginIdUniqueness(extension);
        for (PluginDeclaration plugin : extension.getPlugins()) {
            this.validatePluginConfig(plugin);
        }
    }

    @Override
    public void validatePluginConfig(PluginDeclaration plugin) {
        String pluginName = plugin.getName();
        this.validatePluginId(pluginName, plugin.getId());
        this.validateDisplayName(pluginName, plugin.getDisplayName());
        this.validateDescription(pluginName, plugin.getDescription());
        this.validateImplementationClass(pluginName, plugin.getImplementationClass());
        this.validateTags(plugin);
    }

    @Override
    public void validateTags(PluginDeclaration plugin) {
        Collection<String> tags = Util.getTags(plugin);
        this.validateTags(plugin.getName(), tags);
    }
}

