/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.LoginTask;
import com.gradle.publish.PluginBundleExtension;
import com.gradle.publish.PublishTask;
import com.gradle.publish.PublishTaskShadowAction;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.artifacts.result.DefaultResolvedDependencyResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.util.GradleVersion;
import org.gradle.util.VersionNumber;

public class PublishPlugin
implements Plugin<Project> {
    public static final String JAVA_GRADLE_PLUGIN_ID = "java-gradle-plugin";
    public static final String MAVEN_PUBLISH_PLUGIN_ID = "maven-publish";
    public static final String SHADOW_PLUGIN_ID = "com.github.johnrengelman.shadow";
    public static final String SIGNING_PLUGIN_ID = "signing";
    public static final String LOGIN_TASK_NAME = "login";
    private static final String PUBLISH_TASK_DESCRIPTION = "Publishes this plugin to the Gradle Plugin portal.";
    private static final String LOGIN_TASK_DESCRIPTION = "Update the gradle.properties files so this machine can publish to the Gradle Plugin portal.";
    private static final String PORTAL_BUILD_GROUP_NAME = "Plugin Portal";
    private static final String BASE_TASK_NAME = "publishPlugin";
    private static final String SOURCES_JAR_TASK_NAME = "publishPluginSourcesJar";
    private static final String JAVA_DOCS_TASK_NAME = "publishPluginJavaDocsJar";
    private static final String PUBLISH_TASK_NAME = "publishPlugins";
    public static final String PLUGIN_BUNDLE_EXTENSION_NAME = "pluginBundle";
    static final String SOURCES_CLASSIFIER = "sources";
    static final String JAVADOC_CLASSIFIER = "javadoc";
    private static final Logger LOGGER = Logging.getLogger(PublishPlugin.class);

    public void apply(@Nonnull Project project) {
        PluginBundleExtension bundle;
        if (PublishPlugin.runningOnPreGradle(GradleVersion.version((String)"4.10"))) {
            throw new RuntimeException("This version of the Plugin Publish Plugin isn't compatible with Gradle versions older than 4.10");
        }
        if (PublishPlugin.runningOnPreGradle(GradleVersion.version((String)"6.0"))) {
            project.getPluginManager().withPlugin(SHADOW_PLUGIN_ID, shadowPlugin -> {
                throw new RuntimeException("This version of the Plugin Publish Plugin isn't compatible with the shadow plugin (com.github.johnrengelman.shadow), when running on Gradle versions older than 6.0");
            });
        }
        project.getPlugins().apply("org.gradle.java-library");
        if (PublishPlugin.runningOnPreGradle(GradleVersion.version((String)"8.0-dev-1"))) {
            bundle = new PluginBundleExtension();
            project.getExtensions().add(PLUGIN_BUNDLE_EXTENSION_NAME, (Object)bundle);
        } else {
            bundle = null;
        }
        Log4jVulnerabilityChecker.decorate(project);
        project.getTasks().register(PUBLISH_TASK_NAME, PublishTask.class, publishTask -> {
            publishTask.setDescription(PUBLISH_TASK_DESCRIPTION);
            publishTask.setGroup(PORTAL_BUILD_GROUP_NAME);
            publishTask.setBundleConfig(bundle);
            this.markAsNotCompatibleWithConfigurationCache((PublishTask)((Object)publishTask));
        });
        LOGGER.debug("Setup: publishPlugins of " + this.getClass().getName());
        project.getTasks().register(LOGIN_TASK_NAME, LoginTask.class, loginTask -> {
            loginTask.setDescription(LOGIN_TASK_DESCRIPTION);
            loginTask.setGroup(PORTAL_BUILD_GROUP_NAME);
        });
        LOGGER.debug("Created task: login of " + this.getClass().getName());
        this.wireToJavaGradlePluginAndMavenPublish(project);
        project.afterEvaluate(finalProject -> {
            PublishTask publishTask = (PublishTask)((Object)((Object)project.getTasks().findByName(PUBLISH_TASK_NAME)));
            if (publishTask != null) {
                publishTask.afterProjectEvaluate();
                publishTask.dependsOn(new Object[]{"assemble"});
            }
            project.getPluginManager().withPlugin(SHADOW_PLUGIN_ID, (Action)new PublishTaskShadowAction(project, LOGGER));
            this.forceJavadocAndSourcesJars(project);
        });
    }

    private void markAsNotCompatibleWithConfigurationCache(PublishTask publishTask) {
        if (!PublishPlugin.runningOnPreGradle(GradleVersion.version((String)"7.4"))) {
            try {
                Method method = Task.class.getMethod("notCompatibleWithConfigurationCache", String.class);
                method.invoke((Object)publishTask, "Plugin Publish plugin not yet compatible with Configuration Cache.");
            }
            catch (Exception e) {
                throw new RuntimeException("Failed marking the publishPlugin as not compatible with Configuration Cache", e);
            }
        }
    }

    private void forceJavadocAndSourcesJars(Project project) {
        if (PublishPlugin.runningOnPreGradle(GradleVersion.version((String)"6.0"))) {
            this.registerExtraArtifactProducingTask(project, SOURCES_JAR_TASK_NAME, this.createAndSetupJarSourcesTask(project));
            this.registerExtraArtifactProducingTask(project, JAVA_DOCS_TASK_NAME, this.createAndSetupJavaDocsTask(project));
        } else {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            javaPluginExtension.withJavadocJar();
            javaPluginExtension.withSourcesJar();
        }
    }

    private void registerExtraArtifactProducingTask(Project project, String taskName, TaskProvider<Jar> taskProvider) {
        Task task = (Task)project.getTasks().findByName(taskName);
        if (task == null) {
            task = (Task)taskProvider.get();
        }
        Task assembleTask = (Task)project.getTasks().findByName("assemble");
        assembleTask.dependsOn(new Object[]{task});
        PublishingExtension publishing = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
        MavenPublicationInternal publication = (MavenPublicationInternal)publishing.getPublications().getByName("pluginMaven");
        if (!publication.getArtifacts().contains((Object)task)) {
            publication.getArtifacts().artifact((Object)task);
        }
    }

    private TaskProvider<Jar> createAndSetupJavaDocsTask(Project project) {
        return this.createBasicDocJarTask(project, JAVA_DOCS_TASK_NAME, JAVADOC_CLASSIFIER, "Assembles a jar archive containing the documentation for the main Java source code.", (Action<? super Jar>)((Action)docsTask -> {
            Javadoc javadoc = (Javadoc)project.getTasks().findByName(JAVADOC_CLASSIFIER);
            docsTask.from(new Object[]{javadoc.getDestinationDir()});
        }));
    }

    private TaskProvider<Jar> createBasicDocJarTask(Project project, String name, String classifier, String description, Action<? super Jar> extraConfigAction) {
        return project.getTasks().register(name, Jar.class, docsTask -> {
            docsTask.setDescription(description);
            docsTask.setGroup("build");
            if (PublishPlugin.runningOnPreGradle(GradleVersion.version((String)"7.0"))) {
                docsTask.setClassifier(classifier);
            } else {
                docsTask.getArchiveClassifier().set((Object)classifier);
            }
            extraConfigAction.execute(docsTask);
        });
    }

    private TaskProvider<Jar> createAndSetupJarSourcesTask(Project project) {
        return project.getTasks().register(SOURCES_JAR_TASK_NAME, Jar.class, sourcesTask -> {
            sourcesTask.setDescription("Assembles a jar archive containing the main source code.");
            sourcesTask.setGroup("build");
            if (PublishPlugin.runningOnPreGradle(GradleVersion.version((String)"7.0"))) {
                sourcesTask.setClassifier(SOURCES_CLASSIFIER);
            } else {
                sourcesTask.getArchiveClassifier().set((Object)SOURCES_CLASSIFIER);
            }
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
            SourceSet mainSourceSet = (SourceSet)javaPluginConvention.getSourceSets().getByName("main");
            SourceDirectorySet allMainSources = mainSourceSet.getAllSource();
            sourcesTask.from(new Object[]{allMainSources});
        });
    }

    private void wireToJavaGradlePluginAndMavenPublish(Project project) {
        project.getPluginManager().apply(JAVA_GRADLE_PLUGIN_ID);
        GradlePluginDevelopmentExtension pluginDevelopmentExtension = (GradlePluginDevelopmentExtension)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
        if (PublishPlugin.runningOnPreGradle(GradleVersion.version((String)"7.6-dev-1")) && !pluginDevelopmentExtension.isAutomatedPublishing()) {
            throw new RuntimeException("Since version 1.0 of the Plugin Publish plugin non-automatic publishing is not allowed anymore; the Maven Publish plugin must be used to generate publication metadata");
        }
        project.getPluginManager().apply(MAVEN_PUBLISH_PLUGIN_ID);
    }

    private static boolean runningOnPreGradle(GradleVersion version) {
        return GradleVersion.current().compareTo(version) < 0;
    }

    private static class Log4jVulnerabilityChecker {
        public static final String ERROR_MESSAGE = "Cannot publish a plugin which resolves a vulnerable Log4j version (https://blog.gradle.org/log4j-vulnerability). Make sure to update your configuration so it does not happen.";

        private Log4jVulnerabilityChecker() {
        }

        static void decorate(Project project) {
            project.getConfigurations().all(conf -> {
                ResolvableDependencies incoming = conf.getIncoming();
                incoming.afterResolve(rd -> {
                    ResolutionResult resolutionResult = rd.getResolutionResult();
                    resolutionResult.allDependencies(dependencyResult -> {
                        ModuleComponentIdentifier moduleComponentIdentifier;
                        ComponentIdentifier componentIdentifier;
                        if (dependencyResult instanceof DefaultResolvedDependencyResult && (componentIdentifier = ((DefaultResolvedDependencyResult)dependencyResult).getSelected().getId()) instanceof ModuleComponentIdentifier && Log4jVulnerabilityChecker.isVulnerableLog4jDependency(moduleComponentIdentifier = (ModuleComponentIdentifier)componentIdentifier)) {
                            throw new GradleException(ERROR_MESSAGE);
                        }
                    });
                });
            });
        }

        private static boolean isVulnerableLog4jDependency(ModuleComponentIdentifier identifier) {
            if (!"org.apache.logging.log4j".equals(identifier.getGroup())) {
                return false;
            }
            if (!"log4j-core".equals(identifier.getModule())) {
                return false;
            }
            VersionNumber versionNumber = VersionNumber.parse((String)identifier.getVersion());
            return versionNumber.compareTo(new VersionNumber(2, 0, 0, "alpha1")) >= 0 && versionNumber.compareTo(new VersionNumber(2, 17, 1, null)) < 0;
        }
    }
}

