/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.PluginBundleExtension;
import com.gradle.publish.protocols.v1.models.ClientRequest;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URL;
import java.util.Collection;
import org.gradle.plugin.devel.PluginDeclaration;

public class Util {
    public static boolean isBlank(String src) {
        return src == null || src.trim().isEmpty();
    }

    public static String toHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        return String.format("%0" + (bytes.length << 1) + "X", bi);
    }

    public static <Resp, Req extends ClientRequest<Resp>> Resp convertResponse(Req request, URL url, String response, int statusCode) {
        return Util.convertResponse(request, url.toExternalForm(), response, statusCode);
    }

    public static <Resp, Req extends ClientRequest<Resp>> Resp convertResponse(Req request, String url, String response, int statusCode) {
        try {
            return request.convertResponse(response);
        }
        catch (Exception e) {
            throw new RuntimeException("Error communicating with server.\nURL " + url + " returned response code " + statusCode);
        }
    }

    static Collection<String> getTags(PluginBundleExtension bundleConfig, PluginDeclaration plugin) {
        Collection<String> tags = Util.getTags(plugin);
        if (tags != null && !tags.isEmpty()) {
            return tags;
        }
        tags = bundleConfig.getPluginTags().get(plugin.getName());
        if (tags != null && !tags.isEmpty()) {
            return tags;
        }
        return bundleConfig.getTags();
    }

    private static Collection<String> getTags(PluginDeclaration plugin) {
        try {
            Method getTagsMethod = PluginDeclaration.class.getMethod("getTags", new Class[0]);
            return (Collection)getTagsMethod.invoke((Object)plugin, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

