/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.ConfigurationVariantDetails;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.AppliedPlugin;

public class PublishTaskShadowAction
implements Action<AppliedPlugin> {
    private final Project project;
    private final Logger logger;

    public PublishTaskShadowAction(Project project, Logger logger) {
        this.project = project;
        this.logger = logger;
    }

    public void execute(AppliedPlugin appliedPlugin) {
        this.logger.lifecycle("Shadow plugin detected. Will automatically select a fat jar as the main plugin artifact.");
        ConfigurationContainer configurations = this.project.getConfigurations();
        if (configurations.getByName("shadowRuntimeElements").getAllArtifacts().stream().anyMatch(a -> a.getClassifier() != null && !a.getClassifier().isEmpty())) {
            throw new RuntimeException("Please configure the `shadowJar` task to not add a classifier to the jar it produces");
        }
        SoftwareComponent javaComponent = (SoftwareComponent)this.project.getComponents().getByName("java");
        AdhocComponentWithVariants adhocComponent = (AdhocComponentWithVariants)javaComponent;
        adhocComponent.addVariantsFromConfiguration(configurations.getByName("apiElements"), ConfigurationVariantDetails::skip);
        adhocComponent.addVariantsFromConfiguration(configurations.getByName("runtimeElements"), ConfigurationVariantDetails::skip);
        adhocComponent.addVariantsFromConfiguration(configurations.getByName("shadowRuntimeElements"), configVariantDetails -> configVariantDetails.mapToMavenScope("runtime"));
    }
}

