/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish.protocols.v1.models.publish;

public enum ArtifactType {
    JAR("jar"),
    POM("pom"),
    SOURCES("jar", "sources"),
    JAVADOC("jar", "javadoc"),
    GROOVYDOC("jar", "groovydoc");

    private final String extension;
    private final String classifier;

    private ArtifactType(String extension, String classifier) {
        this.extension = extension;
        this.classifier = classifier;
    }

    private ArtifactType(String extension) {
        this(extension, "");
    }

    public static ArtifactType find(String extension, String classifier) {
        if (classifier == null) {
            classifier = "";
        }
        for (ArtifactType type : ArtifactType.values()) {
            if (!type.extension.equals(extension) || !type.classifier.equals(classifier)) continue;
            return type;
        }
        return null;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getClassifier() {
        return this.classifier.isEmpty() ? null : this.classifier;
    }
}

