/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.PomWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependenciesBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomWriter.class);

    public List<Dependency> buildMavenDependencies(ConfigurationContainer configurations) {
        Configuration compile = configurations.getByName("compile");
        Configuration runtime = configurations.getByName("runtime");
        return this.getDependencies(compile, runtime);
    }

    private List<Dependency> getDependencies(Configuration compile, Configuration runtime) {
        ArrayList<Dependency> mavenDeps = new ArrayList<Dependency>();
        this.addDependencies(mavenDeps, compile, "compile");
        this.addDependencies(mavenDeps, runtime, "runtime");
        return mavenDeps;
    }

    private void addDependencies(List<Dependency> mavenDeps, Configuration config, String scope) {
        for (org.gradle.api.artifacts.Dependency dep : config.getDependencies()) {
            if (!(dep instanceof ModuleDependency)) continue;
            this.addDependency(mavenDeps, (ModuleDependency)dep, scope);
        }
    }

    private void addDependency(List<Dependency> mavenDeps, ModuleDependency dep, String scope) {
        Set excludeRules;
        Dependency mavenDep = new Dependency();
        mavenDep.setGroupId(dep.getGroup());
        mavenDep.setArtifactId(dep.getName());
        mavenDep.setVersion(dep.getVersion());
        mavenDep.setScope(scope);
        if (!dep.isTransitive()) {
            LOGGER.warn(String.format("Dependency %s:%s:%s is marked as non-transitive, but this is notsupported by the underlying Maven publishing mechanism", dep.getGroup(), dep.getName(), dep.getVersion()));
        }
        if ((excludeRules = dep.getExcludeRules()) != null) {
            for (ExcludeRule e : excludeRules) {
                Exclusion mavenEx = new Exclusion();
                mavenEx.setGroupId(e.getGroup());
                mavenEx.setArtifactId(e.getModule());
                mavenDep.addExclusion(mavenEx);
            }
        }
        mavenDeps.add(mavenDep);
    }
}

