/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.protocols.v1.models.publish.PublishMavenCoordinates;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PomWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomWriter.class);
    private Document doc;

    public void writePom(File target, PublishMavenCoordinates coords, List<Dependency> deps) throws IOException {
        this.createPomDocument(coords, deps);
        this.writeFile(target);
    }

    private void createPomDocument(PublishMavenCoordinates coords, List<Dependency> deps) {
        Element project = this.createDomDocument();
        this.appendTextNode(project, "modelVersion", "4.0.0");
        this.appendTextNode(project, "groupId", coords.getGroupId());
        this.appendTextNode(project, "artifactId", coords.getArtifactId());
        this.appendTextNode(project, "version", coords.getVersion());
        if (deps != null && !deps.isEmpty()) {
            Element depsNode = this.doc.createElement("dependencies");
            project.appendChild(depsNode);
            for (Dependency dep : deps) {
                this.addDependency(depsNode, dep);
            }
        }
    }

    private void addDependency(Element depsNode, Dependency dep) {
        Element depNode = this.doc.createElement("dependency");
        depsNode.appendChild(depNode);
        this.appendTextNode(depNode, "groupId", dep.getGroupId());
        this.appendTextNode(depNode, "artifactId", dep.getArtifactId());
        this.appendTextNode(depNode, "version", dep.getVersion());
        this.appendTextNodeIfPresent(depNode, "classifier", dep.getClassifier());
        this.appendTextNodeIfPresent(depNode, "scope", dep.getScope());
        this.appendTextNodeIfPresent(depNode, "type", dep.getType());
        this.appendTextNodeIfPresent(depNode, "optional", dep.getOptional());
        List exclusions = dep.getExclusions();
        if (exclusions != null && !exclusions.isEmpty()) {
            Element exsNode = this.doc.createElement("exclusions");
            depNode.appendChild(exsNode);
            for (Exclusion ex : exclusions) {
                Element exNode = this.doc.createElement("exclusion");
                exsNode.appendChild(exNode);
                this.appendTextNodeIfPresent(exNode, "groupId", ex.getGroupId());
                this.appendTextNodeIfPresent(exNode, "artifactId", ex.getArtifactId());
            }
        }
    }

    private static boolean hasValue(String val) {
        return val != null && !val.isEmpty();
    }

    private Element createDomDocument() {
        try {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation().createDocument("http://maven.apache.org/POM/4.0.0", "project", null);
        }
        catch (ParserConfigurationException e) {
            PomWriter.handleXmlException(e);
        }
        Element project = this.doc.getDocumentElement();
        project.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd");
        return project;
    }

    private void appendTextNodeIfPresent(Element parent, String name, String value) {
        if (PomWriter.hasValue(value)) {
            this.appendTextNode(parent, name, value);
        }
    }

    private void appendTextNode(Element parent, String name, String value) {
        Element node = this.doc.createElement(name);
        node.appendChild(this.doc.createTextNode(value));
        parent.appendChild(node);
    }

    private void writeFile(File target) {
        target.getParentFile().mkdirs();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(this.doc);
            StreamResult result = new StreamResult(target);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            PomWriter.handleXmlException(e);
        }
    }

    private static void handleXmlException(Exception e) {
        throw new RuntimeException("Error generating pom", e);
    }
}

