/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.receipts.protocols.v1.models;

import com.gradle.receipts.protocols.v1.models.ReceiptFragmentStability;

public enum ReceiptFragmentType {
    PROJECT("project", ReceiptFragmentStability.PER_PROJECT),
    PROJECT_STARTED("project_started", ReceiptFragmentStability.PER_BUILD),
    PROJECT_COMPLETED("project_completed", ReceiptFragmentStability.PER_BUILD),
    BUILD_RESULT("build_result", ReceiptFragmentStability.PER_BUILD),
    BUILD_COMPLETED("build_completed", ReceiptFragmentStability.PER_BUILD),
    DEPENDENCIES("dependencies", ReceiptFragmentStability.PER_PROJECT),
    SYSTEM("system", ReceiptFragmentStability.CROSS_PROJECT),
    TASK_STARTED("task_started", ReceiptFragmentStability.PER_BUILD),
    TASK_COMPLETED("task_completed", ReceiptFragmentStability.PER_BUILD),
    VCS("vcs", ReceiptFragmentStability.PER_PROJECT);

    private final String id;
    private final ReceiptFragmentStability stability;

    private ReceiptFragmentType(String id, ReceiptFragmentStability stability) {
        this.id = id;
        this.stability = stability;
    }

    public ReceiptFragmentStability getStability() {
        return this.stability;
    }

    public String getId() {
        return this.id;
    }

    public static ReceiptFragmentType forId(String id) {
        for (ReceiptFragmentType type : ReceiptFragmentType.values()) {
            if (!type.getId().equals(id)) continue;
            return type;
        }
        throw new IllegalArgumentException("Cannot find receipt fragment type for id " + id);
    }
}

