/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.InvalidPluginIdException;
import com.gradle.publish.MavenCoordinates;
import com.gradle.publish.PluginBundleExtension;
import com.gradle.publish.PluginConfig;
import com.gradle.publish.PluginId;
import com.gradle.publish.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;

public class PluginPublishValidator {
    private static final Collection<String> FORBIDDEN_NAMESPACES = Collections.unmodifiableList(Arrays.asList("org.gradle", "com.gradleware", "com.gradle", "org.samples.greeting"));
    private final String projectVersion;
    private final boolean skipNamespaceCheck;
    private final boolean versionOverride;
    private static final Pattern MAVEN_ID_REGEX = Pattern.compile("[A-Za-z0-9_\\-.]+");

    public PluginPublishValidator(String projectVersion, boolean skipNamespaceCheck, boolean versionOverride) {
        this.projectVersion = projectVersion;
        this.skipNamespaceCheck = skipNamespaceCheck;
        this.versionOverride = versionOverride;
    }

    public void validateMavenCoordinates(String groupId, String artifactId, String version, MavenCoordinates coordinates) {
        String specifiedArtifactId;
        if (Util.isBlank(groupId)) {
            throw new IllegalArgumentException("Cannot publish artifacts as no group ID set.\nPlease set the group at the project level or the group ID in the\nmavenCoordinates block inside your pluginBundle config.");
        }
        if (!MAVEN_ID_REGEX.matcher(groupId).matches()) {
            boolean specifiedGroupId = coordinates != null && !Util.isBlank(coordinates.getGroupId());
            String extraHelp = specifiedGroupId ? "" : "\nBy default the project group is used as the group ID. You can override this by setting\nthe groupId property in the mavenCoordinates block inside your pluginBundle config.";
            throw new IllegalArgumentException("Cannot publish artifacts as group ID '" + groupId + "' is invalid.\nValid group IDs may include alphanumeric characters, numbers, dashes,\nunderscores and dots." + extraHelp);
        }
        if (this.failsNamespaceCheck(groupId)) {
            throw new IllegalArgumentException("Cannot publish artifacts as group ID '" + groupId + "' is not allowed.\nGroup IDs cannot begin with " + String.join((CharSequence)", ", FORBIDDEN_NAMESPACES));
        }
        String string = specifiedArtifactId = coordinates != null ? coordinates.getArtifactId() : null;
        if (!MAVEN_ID_REGEX.matcher(artifactId).matches()) {
            String extraHelp = !Util.isBlank(specifiedArtifactId) ? "" : "\nBy default the project name is used as the artifact ID. You can override this by setting\nthe artifactId property in the mavenCoordinates block inside your pluginBundle config.";
            throw new IllegalArgumentException("Cannot publish artifacts as artifact ID '" + artifactId + "' is invalid.\nValid artifact IDs may include alphanumeric characters, numbers, dashes,\nunderscores and dots." + extraHelp);
        }
        if (artifactId.equals(groupId + ".gradle.plugin")) {
            throw new IllegalArgumentException("Group ID + '.gradle.plugin' suffix not allowed as artifact ID");
        }
        if (Util.isBlank(version) || version.equals("unspecified")) {
            throw new IllegalArgumentException("Cannot publish artifacts as no version set.\nPlease set the version at the project level or in the mavenCoordinates block\ninside your pluginBundle config.");
        }
    }

    public void validateBundle(PluginBundleExtension bundleConfig) {
        if (bundleConfig.getPlugins().isEmpty()) {
            throw new IllegalArgumentException("No plugins defined. Please declare at least one plugin in a pluginBundle plugins block");
        }
        this.validateURL(bundleConfig.getWebsite(), "website");
        this.validateURL(bundleConfig.getVcsUrl(), "VCS");
        this.validatePluginIdUniqueness(bundleConfig);
        for (PluginConfig plugin : bundleConfig.getPlugins()) {
            this.validatePluginConfig(bundleConfig, plugin);
        }
    }

    private void validateURL(String url, String description) {
        if (Util.isBlank(url)) {
            throw new IllegalArgumentException("Plugin bundle has no " + description + " URL set, please set the property in pluginBundle config.\nExample value: 'https://github.com/username/repo'");
        }
        try {
            URI normalizedURI = new URI(url.toLowerCase());
            String scheme = normalizedURI.getScheme();
            if (!scheme.equals("http") && !scheme.equals("https")) {
                throw new IllegalArgumentException("Plugin bundle " + description + " URL only supports HTTP or HTTPS schemas, please set the property in the pluginBundle config accordingly.\nExample value: 'https://github.com/username/repo'");
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Can't parse URL '" + url + "'");
        }
    }

    private void validateTags(PluginBundleExtension bundleConfig, PluginConfig plugin) {
        Collection<String> configTags = plugin.getTags();
        if (configTags.isEmpty()) {
            configTags = bundleConfig.getTags();
        }
        if (configTags.isEmpty()) {
            throw new IllegalArgumentException("Plugin bundle has no tags, please set the tags property in the pluginBundle config.\nExample: tags = ['test', 'integration']");
        }
    }

    public void validatePluginConfig(PluginBundleExtension bundleConfig, PluginConfig plugin) {
        String pluginName = plugin.getName();
        this.validatePluginId(pluginName, plugin.getId());
        String pluginVersion = plugin.getVersion() != null ? plugin.getVersion() : this.projectVersion;
        this.validateVersion(plugin.getName(), pluginVersion);
        if (Util.isBlank(plugin.getDisplayName())) {
            throw new IllegalArgumentException("Plugin " + plugin.getName() + " has no display name, please set the displayName property in the plugin config.\nExample: displayName = 'My Widget Plugin'");
        }
        String desc = plugin.getDescription();
        String string = desc = desc != null ? desc : bundleConfig.getDescription();
        if (Util.isBlank(desc)) {
            throw new IllegalArgumentException("Plugin " + plugin.getName() + " has no description, please set the description property\nin the plugin config or the pluginBundle config.\nExample: description = 'This plugin adds some tasks and makes you coffee'");
        }
        this.validateTags(bundleConfig, plugin);
    }

    private void validateVersion(String pluginName, String version) {
        if (this.versionOverride) {
            return;
        }
        String regExp = "[a-zA-Z0-9\\-\\.\\[\\]\\:\\+]*";
        String numberRegExp = ".*?[0-9].*?";
        if (Util.isBlank(version) || version.equals("unspecified")) {
            throw new IllegalArgumentException("Plugin " + pluginName + " does not define a version.\nPlease set the version property in the plugin config, or set the project version");
        }
        if (!version.matches(numberRegExp) || !version.matches(regExp) || version.length() > 50) {
            throw new RuntimeException("Invalid version '" + version + "'. Set 'version' property string must with a string that: 1) is not empty and less than 50 characters long; 2) includes a number; and 3) that matches the regular expression: " + regExp);
        }
        if (version.trim().endsWith("-SNAPSHOT")) {
            throw new IllegalArgumentException("-SNAPSHOT plugin versions not supported, please use a fixed version instead.");
        }
    }

    private void validatePluginId(String pluginName, String pluginId) {
        if (pluginId == null || pluginId.isEmpty()) {
            throw new IllegalArgumentException("Plugin " + pluginName + " does not define a plugin ID. Please set the 'id' property in the plugin config");
        }
        PluginId id = PluginId.of(pluginId);
        if (!id.isQualified()) {
            throw new InvalidPluginIdException(pluginId, "Plugin IDs should be namespaced, e.g. 'com.example." + pluginId + "'");
        }
        if (this.failsNamespaceCheck(pluginId)) {
            throw new InvalidPluginIdException(pluginId, "cannot begin with " + FORBIDDEN_NAMESPACES);
        }
    }

    private void validatePluginIdUniqueness(PluginBundleExtension bundleConfig) {
        HashSet<String> usedPluginIds = new HashSet<String>();
        for (PluginConfig plugin : bundleConfig.getPlugins()) {
            String pluginId = plugin.getId();
            if (usedPluginIds.contains(pluginId)) {
                throw new InvalidPluginIdException(pluginId, "multiple plugins are using the same ID");
            }
            usedPluginIds.add(pluginId);
        }
    }

    private boolean failsNamespaceCheck(String id) {
        if (!this.skipNamespaceCheck) {
            id = id.toLowerCase();
            for (String ns : FORBIDDEN_NAMESPACES) {
                if (!id.equals(ns) && !id.startsWith(ns + ".")) continue;
                return true;
            }
        }
        return false;
    }
}

