/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.Config;
import com.gradle.publish.PropertiesStore;
import com.gradle.publish.RequestUtil;
import com.gradle.publish.ResponseUtil;
import com.gradle.publish.Util;
import com.gradle.publish.plugin.dep.org.apache.commons.io.IOUtils;
import com.gradle.publish.protocols.v1.models.login.LoginCheckRequest;
import com.gradle.publish.protocols.v1.models.login.LoginCheckResponse;
import com.gradle.publish.protocols.v1.models.login.LoginInitRequest;
import com.gradle.publish.protocols.v1.models.login.LoginInitResponse;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.LinkedHashMap;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;

public class LoginTask
extends DefaultTask {
    private Config ghConfig = new Config(this.getProject());

    private boolean isLoggedIn(LoginCheckRequest loginCheckRequest) throws IOException {
        URL url = new URL(this.ghConfig.getPortalUrl() + loginCheckRequest.requestProtocolURL());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(loginCheckRequest.getRequestMethod());
        String response = IOUtils.toString(connection.getInputStream());
        this.getLogger().debug("Is logged in response: " + response);
        LoginCheckResponse loginCheckResponse = (LoginCheckResponse)loginCheckRequest.convertResponse(response);
        ResponseUtil.assertValidResponse("Failed checking if user is logged in.", loginCheckResponse);
        connection.disconnect();
        if (loginCheckResponse.getCompleted().booleanValue()) {
            String key = loginCheckResponse.getKey();
            String secret = loginCheckResponse.getSecret();
            this.updateKeySecretProperties(key, secret, loginCheckResponse.getSuccessMessage());
        }
        return loginCheckResponse.getCompleted();
    }

    static File getGradleHomePropertiesFile(Project project) {
        File defaultGradleDir = project.getGradle().getGradleUserHomeDir();
        return new File(defaultGradleDir, "gradle.properties");
    }

    private void updateKeySecretProperties(String key, String secret, String message) throws IOException {
        File propertiesFile = LoginTask.getGradleHomePropertiesFile(this.getProject());
        this.getLogger().debug("Updating key and secret in file: " + propertiesFile.getAbsolutePath());
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("gradle.publish.key", key);
        props.put("gradle.publish.secret", secret);
        PropertiesStore.append(propertiesFile, props, "Updated secret and key with server message: " + message);
        this.getLogger().quiet("Your publishing API keys have been written to: " + propertiesFile.getAbsolutePath());
    }

    @TaskAction
    public void login() throws IOException, InterruptedException {
        String keyName = InetAddress.getLocalHost().getHostName();
        LoginInitRequest request = new LoginInitRequest(keyName);
        URL url = new URL(this.ghConfig.getPortalUrl() + request.requestProtocolURL());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(request.getRequestMethod());
        RequestUtil.addClientVersionAsRequestHeader(connection);
        String stringResponse = IOUtils.toString(connection.getInputStream());
        int status = connection.getResponseCode();
        this.getLogger().debug("Login response: " + stringResponse);
        LoginInitResponse apiResponse = (LoginInitResponse)Util.convertResponse(request, url, stringResponse, status);
        ResponseUtil.assertValidResponse("Failed login initialization request.", apiResponse);
        File propertiesFile = LoginTask.getGradleHomePropertiesFile(this.getProject());
        this.getLogger().quiet("\nTo add your publishing API keys to " + propertiesFile.getAbsolutePath() + ", open the following URL in your browser:\n\n   " + apiResponse.getValidateUrl() + "\n\n");
        connection.disconnect();
        Long startTime = System.currentTimeMillis();
        while (!this.isLoggedIn(apiResponse.getNextRequest()) && System.currentTimeMillis() - startTime < this.ghConfig.loginMaxWait()) {
            Thread.sleep(this.ghConfig.loginSleepInterval());
            this.getLogger().trace("Trying login again: " + apiResponse.getToken());
        }
    }
}

