/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.Util;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class Hasher {
    static ThreadLocal<MessageDigest> md = new ThreadLocal<MessageDigest>(){

        @Override
        public MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hash(byte[] bytes) {
        MessageDigest currentMd = md.get();
        currentMd.reset();
        try {
            currentMd.update(bytes);
            String string = Util.toHex(currentMd.digest()).toLowerCase();
            return string;
        }
        finally {
            currentMd.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hash(InputStream is) throws IOException {
        MessageDigest currentMd = md.get();
        currentMd.reset();
        try {
            byte[] buf = new byte[4096];
            int len = is.read(buf);
            while (len > 0) {
                currentMd.update(buf, 0, len);
                len = is.read(buf);
            }
            String string = Util.toHex(currentMd.digest()).toLowerCase();
            return string;
        }
        finally {
            currentMd.reset();
        }
    }
}

