/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.obfuscation;

import com.gradle.obfuscation.Keep;
import com.gradle.obfuscation.KeepName;
import com.gradle.obfuscation.KeepNameAndProperties;
import com.gradle.obfuscation.KeepProperties;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ObfuscationControl {
    public static boolean retainsPropertyNames(Class<?> clazz) {
        return ObfuscationControl.hasRetention(clazz, b.PROPERTIES);
    }

    public static void requireClassName(Class<?> clazz, Supplier<String> reason) {
        ObfuscationControl.requireRetention(clazz, b.CLASS_NAME, reason);
    }

    public static void requireClassNameAndProperties(Class<?> clazz, Supplier<String> reason) {
        ObfuscationControl.requireRetention(clazz, b.CLASS_NAME_AND_PROPERTIES, reason);
    }

    public static void requireAll(Class<?> clazz, Supplier<String> reason) {
        ObfuscationControl.requireRetention(clazz, b.ALL, reason);
    }

    private static void requireRetention(Class<?> clazz, b retention, Supplier<String> reason) {
        if (!ObfuscationControl.hasRetention(clazz, retention)) {
            throw new IllegalStateException("Class " + clazz.getName() + " requires " + retention.name() + " retention (" + retention.a() + "). Reason: " + reason.get());
        }
    }

    private static boolean hasRetention(Class<?> clazz, b retention) {
        if (ObfuscationControl.isObfuscatable(clazz)) {
            for (a annotationSet : retention.a) {
                if (!annotationSet.a(clazz)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean isObfuscatable(Class<?> clazz) {
        return clazz.getName().startsWith("com.gradle.") && !clazz.getName().startsWith("com.gradle.enterprise.testdistribution.internal.dep.com.gradle.scan.eventmodel");
    }

    private ObfuscationControl() {
    }

    private static final class a {
        final Class<? extends Annotation>[] a;

        @SafeVarargs
        a(Class<? extends Annotation> ... annotations) {
            this.a = annotations;
        }

        boolean a(Class<?> clazz) {
            for (Class<? extends Annotation> annotation : this.a) {
                if (clazz.isAnnotationPresent(annotation)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return Arrays.stream(this.a).map(Class::getSimpleName).map(s2 -> "@" + s2).collect(Collectors.joining(" and "));
        }
    }

    private static enum b {
        ALL(new a(Keep.class)),
        CLASS_NAME(new a(Keep.class), new a(KeepName.class), new a(KeepNameAndProperties.class)),
        CLASS_NAME_AND_PROPERTIES(new a(Keep.class), new a(KeepName.class, KeepProperties.class), new a(KeepNameAndProperties.class)),
        PROPERTIES(new a(Keep.class), new a(KeepProperties.class), new a(KeepNameAndProperties.class));

        private final a[] a;

        private b(a ... annotationSets) {
            this.a = annotationSets;
        }

        public String a() {
            return Arrays.stream(this.a).map(Object::toString).collect(Collectors.joining(", or "));
        }
    }
}

