/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.common.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public class ReflectUtils {
    private static StringBuilder appendTypeName(StringBuilder sb, Type type, boolean ellipses) {
        if (type instanceof Class) {
            Class<?> ctype = (Class<?>)type;
            if (ctype.isArray()) {
                try {
                    int dimensions = 0;
                    while (ctype.isArray()) {
                        ++dimensions;
                        ctype = ctype.getComponentType();
                    }
                    sb.append(ctype.getName());
                    for (int i2 = 0; i2 < dimensions; ++i2) {
                        if (ellipses) {
                            sb.append("...");
                            continue;
                        }
                        sb.append("[]");
                    }
                    return sb;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            sb.append(ctype.getName());
        } else {
            sb.append(type.toString());
        }
        return sb;
    }

    public static String toString(Class<?> pojo, Method method) {
        StringBuilder str = new StringBuilder();
        int mod = method.getModifiers() & Modifier.methodModifiers();
        if (mod != 0) {
            str.append(Modifier.toString(mod)).append(' ');
        }
        Type retType = method.getGenericReturnType();
        ReflectUtils.appendTypeName(str, retType, false).append(' ');
        str.append(pojo.getName());
        str.append("#");
        str.append(method.getName());
        str.append('(');
        Type[] params = method.getGenericParameterTypes();
        for (int j2 = 0; j2 < params.length; ++j2) {
            boolean ellipses = method.isVarArgs() && j2 == params.length - 1;
            ReflectUtils.appendTypeName(str, params[j2], ellipses);
            if (j2 >= params.length - 1) continue;
            str.append(", ");
        }
        str.append(')');
        return str.toString();
    }
}

