/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.common;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.api.ProtocolException;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.api.WebSocketBehavior;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.api.extensions.Extension;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.api.extensions.Frame;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.common.CloseInfo;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.common.OpCode;
import java.nio.ByteBuffer;
import java.util.List;

public class Generator {
    private final WebSocketBehavior behavior;
    private final ByteBufferPool bufferPool;
    private final boolean validating;
    private final boolean readOnly;
    private byte flagsInUse = 0;

    public Generator(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this(policy, bufferPool, true, false);
    }

    public Generator(WebSocketPolicy policy, ByteBufferPool bufferPool, boolean validating, boolean readOnly) {
        this.behavior = policy.getBehavior();
        this.bufferPool = bufferPool;
        this.validating = validating;
        this.readOnly = readOnly;
    }

    public void assertFrameValid(Frame frame) {
        if (!this.validating) {
            return;
        }
        if (frame.isRsv1() && !this.isRsv1InUse()) {
            throw new ProtocolException("RSV1 not allowed to be set");
        }
        if (frame.isRsv2() && !this.isRsv2InUse()) {
            throw new ProtocolException("RSV2 not allowed to be set");
        }
        if (frame.isRsv3() && !this.isRsv3InUse()) {
            throw new ProtocolException("RSV3 not allowed to be set");
        }
        if (OpCode.isControlFrame(frame.getOpCode())) {
            ByteBuffer payload;
            if (frame.getPayloadLength() > 125) {
                throw new ProtocolException("Invalid control frame payload length");
            }
            if (!frame.isFin()) {
                throw new ProtocolException("Control Frames must be FIN=true");
            }
            if (frame.getOpCode() == 8 && (payload = frame.getPayload()) != null) {
                new CloseInfo(payload, true);
            }
        }
    }

    public void configureFromExtensions(List<? extends Extension> exts) {
        this.flagsInUse = 0;
        for (Extension extension : exts) {
            if (extension.isRsv1User()) {
                this.flagsInUse = (byte)(this.flagsInUse | 0x40);
            }
            if (extension.isRsv2User()) {
                this.flagsInUse = (byte)(this.flagsInUse | 0x20);
            }
            if (!extension.isRsv3User()) continue;
            this.flagsInUse = (byte)(this.flagsInUse | 0x10);
        }
    }

    public ByteBuffer generateHeaderBytes(Frame frame) {
        ByteBuffer buffer = this.bufferPool.acquire(28, true);
        this.generateHeaderBytes(frame, buffer);
        return buffer;
    }

    public void generateHeaderBytes(Frame frame, ByteBuffer buffer) {
        int p2 = BufferUtil.flipToFill(buffer);
        this.assertFrameValid(frame);
        byte b2 = 0;
        if (frame.isFin()) {
            b2 = (byte)(b2 | 0x80);
        }
        if (frame.isRsv1()) {
            b2 = (byte)(b2 | 0x40);
        }
        if (frame.isRsv2()) {
            b2 = (byte)(b2 | 0x20);
        }
        if (frame.isRsv3()) {
            b2 = (byte)(b2 | 0x10);
        }
        byte opcode = frame.getOpCode();
        if (frame.getOpCode() == 0) {
            opcode = 0;
        }
        b2 = (byte)(b2 | opcode & 0xF);
        buffer.put(b2);
        b2 = frame.isMasked() ? (byte)-128 : 0;
        int payloadLength = frame.getPayloadLength();
        if (payloadLength > 65535) {
            b2 = (byte)(b2 | 0x7F);
            buffer.put(b2);
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)(payloadLength >> 24 & 0xFF));
            buffer.put((byte)(payloadLength >> 16 & 0xFF));
            buffer.put((byte)(payloadLength >> 8 & 0xFF));
            buffer.put((byte)(payloadLength & 0xFF));
        } else if (payloadLength >= 126) {
            b2 = (byte)(b2 | 0x7E);
            buffer.put(b2);
            buffer.put((byte)(payloadLength >> 8));
            buffer.put((byte)(payloadLength & 0xFF));
        } else {
            b2 = (byte)(b2 | payloadLength & 0x7F);
            buffer.put(b2);
        }
        if (frame.isMasked() && !this.readOnly) {
            byte[] mask = frame.getMask();
            buffer.put(mask);
            int maskInt = 0;
            for (byte maskByte : mask) {
                maskInt = (maskInt << 8) + (maskByte & 0xFF);
            }
            ByteBuffer payload = frame.getPayload();
            if (payload != null && payload.remaining() > 0) {
                int remaining;
                int maskOffset = 0;
                int start = payload.position();
                int end = payload.limit();
                while ((remaining = end - start) > 0) {
                    if (remaining >= 4) {
                        payload.putInt(start, payload.getInt(start) ^ maskInt);
                        start += 4;
                        continue;
                    }
                    payload.put(start, (byte)(payload.get(start) ^ mask[maskOffset & 3]));
                    ++start;
                    ++maskOffset;
                }
            }
        }
        BufferUtil.flipToFlush(buffer, p2);
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public boolean isRsv1InUse() {
        return (this.flagsInUse & 0x40) != 0;
    }

    public boolean isRsv2InUse() {
        return (this.flagsInUse & 0x20) != 0;
    }

    public boolean isRsv3InUse() {
        return (this.flagsInUse & 0x10) != 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Generator[");
        builder.append((Object)this.behavior);
        if (this.validating) {
            builder.append(",validating");
        }
        if (this.isRsv1InUse()) {
            builder.append(",+rsv1");
        }
        if (this.isRsv2InUse()) {
            builder.append(",+rsv2");
        }
        if (this.isRsv3InUse()) {
            builder.append(",+rsv3");
        }
        builder.append("]");
        return builder.toString();
    }
}

