/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.api;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.api.MessageTooLargeException;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.websocket.api.WebSocketBehavior;

public class WebSocketPolicy {
    private int maxTextMessageSize = 65536;
    private int maxTextMessageBufferSize = 32768;
    private int maxBinaryMessageSize = 65536;
    private int maxBinaryMessageBufferSize = 32768;
    private long asyncWriteTimeout = 60000L;
    private long idleTimeout = 300000L;
    private int inputBufferSize = 4096;
    private final WebSocketBehavior behavior;

    public static WebSocketPolicy newClientPolicy() {
        return new WebSocketPolicy(WebSocketBehavior.CLIENT);
    }

    public WebSocketPolicy(WebSocketBehavior behavior) {
        this.behavior = behavior;
    }

    private void assertGreaterThan(String name, long size, long minSize) {
        if (size < minSize) {
            throw new IllegalArgumentException(String.format("%s [%d] must be a greater than or equal to " + minSize, name, size));
        }
    }

    public void assertValidBinaryMessageSize(int requestedSize) {
        if (this.maxBinaryMessageSize > 0 && requestedSize > this.maxBinaryMessageSize) {
            throw new MessageTooLargeException("Binary message size [" + requestedSize + "] exceeds maximum size [" + this.maxBinaryMessageSize + "]");
        }
    }

    public void assertValidTextMessageSize(int requestedSize) {
        if (this.maxTextMessageSize > 0 && requestedSize > this.maxTextMessageSize) {
            throw new MessageTooLargeException("Text message size [" + requestedSize + "] exceeds maximum size [" + this.maxTextMessageSize + "]");
        }
    }

    public WebSocketPolicy clonePolicy() {
        WebSocketPolicy clone = new WebSocketPolicy(this.behavior);
        clone.idleTimeout = this.getIdleTimeout();
        clone.maxTextMessageSize = this.getMaxTextMessageSize();
        clone.maxTextMessageBufferSize = this.getMaxTextMessageBufferSize();
        clone.maxBinaryMessageSize = this.getMaxBinaryMessageSize();
        clone.maxBinaryMessageBufferSize = this.getMaxBinaryMessageBufferSize();
        clone.inputBufferSize = this.getInputBufferSize();
        clone.asyncWriteTimeout = this.getAsyncWriteTimeout();
        return clone;
    }

    @Deprecated
    public long getAsyncWriteTimeout() {
        return this.asyncWriteTimeout;
    }

    public WebSocketBehavior getBehavior() {
        return this.behavior;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public int getMaxBinaryMessageSize() {
        return this.maxBinaryMessageSize;
    }

    public int getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public int getMaxTextMessageSize() {
        return this.maxTextMessageSize;
    }

    public void setIdleTimeout(long ms) {
        this.assertGreaterThan("IdleTimeout", ms, 0L);
        this.idleTimeout = ms;
    }

    public void setInputBufferSize(int size) {
        this.assertGreaterThan("InputBufferSize", size, 1L);
        this.inputBufferSize = size;
    }

    public void setMaxBinaryMessageSize(int size) {
        this.assertGreaterThan("MaxBinaryMessageSize", size, -1L);
        this.maxBinaryMessageSize = size;
    }

    public void setMaxTextMessageSize(int size) {
        this.assertGreaterThan("MaxTextMessageSize", size, -1L);
        this.maxTextMessageSize = size;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(this.hashCode()));
        builder.append("[behavior=").append((Object)this.getBehavior());
        builder.append(",maxTextMessageSize=").append(this.getMaxTextMessageSize());
        builder.append(",maxTextMessageBufferSize=").append(this.getMaxTextMessageBufferSize());
        builder.append(",maxBinaryMessageSize=").append(this.getMaxBinaryMessageSize());
        builder.append(",maxBinaryMessageBufferSize=").append(this.getMaxTextMessageBufferSize());
        builder.append(",asyncWriteTimeout=").append(this.getAsyncWriteTimeout());
        builder.append(",idleTimeout=").append(this.getIdleTimeout());
        builder.append(",inputBufferSize=").append(this.getInputBufferSize());
        builder.append("]");
        return builder.toString();
    }
}

