/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.thread;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.component.AbstractLifeCycle;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class Sweeper
extends AbstractLifeCycle
implements Runnable {
    private static final Logger LOG = Log.getLogger(Sweeper.class);
    private final AtomicReference<List<Sweepable>> items;
    private final AtomicReference<Scheduler.Task> task;
    private final Scheduler scheduler;
    private final long period;

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.items.set(new CopyOnWriteArrayList());
        this.activate();
    }

    @Override
    protected void doStop() throws Exception {
        this.deactivate();
        this.items.set(null);
        super.doStop();
    }

    public boolean offer(Sweepable sweepable) {
        List<Sweepable> refs = this.items.get();
        if (refs == null) {
            return false;
        }
        refs.add(sweepable);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resource offered {}", sweepable);
        }
        return true;
    }

    public boolean remove(Sweepable sweepable) {
        List<Sweepable> refs = this.items.get();
        return refs != null && refs.remove(sweepable);
    }

    @Override
    public void run() {
        List<Sweepable> refs = this.items.get();
        if (refs == null) {
            return;
        }
        for (Sweepable sweepable : refs) {
            try {
                if (!sweepable.sweep()) continue;
                refs.remove(sweepable);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Resource swept {}", sweepable);
            }
            catch (Throwable x2) {
                LOG.info("Exception while sweeping " + sweepable, x2);
            }
        }
        this.activate();
    }

    private void activate() {
        if (this.isRunning()) {
            Scheduler.Task t2 = this.scheduler.schedule(this, this.period, TimeUnit.MILLISECONDS);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduled in {} ms sweep task {}", this.period, t2);
            }
            this.task.set(t2);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Skipping sweep task scheduling", new Object[0]);
        }
    }

    private void deactivate() {
        Scheduler.Task t2 = this.task.getAndSet(null);
        if (t2 != null) {
            boolean cancelled = t2.cancel();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cancelled ({}) sweep task {}", cancelled, t2);
            }
        }
    }

    public static interface Sweepable {
        public boolean sweep();
    }
}

