/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Uptime {
    private static final Uptime INSTANCE = new Uptime();
    private Impl impl;

    public static Uptime getInstance() {
        return INSTANCE;
    }

    private Uptime() {
        try {
            this.impl = new DefaultImpl();
        }
        catch (UnsupportedOperationException e2) {
            System.err.printf("Defaulting Uptime to NOIMPL due to (%s) %s%n", e2.getClass().getName(), e2.getMessage());
            this.impl = null;
        }
    }

    public static long getUptime() {
        Uptime u2 = Uptime.getInstance();
        if (u2 == null || u2.impl == null) {
            return -1L;
        }
        return u2.impl.getUptime();
    }

    public static class DefaultImpl
    implements Impl {
        public Object mxBean;
        public Method uptimeMethod;

        public DefaultImpl() {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> mgmtFactory = Class.forName("java.lang.management.ManagementFactory", true, cl);
                Class<?> runtimeClass = Class.forName("java.lang.management.RuntimeMXBean", true, cl);
                Class[] noparams = new Class[]{};
                Method mxBeanMethod = mgmtFactory.getMethod("getRuntimeMXBean", noparams);
                if (mxBeanMethod == null) {
                    throw new UnsupportedOperationException("method getRuntimeMXBean() not found");
                }
                this.mxBean = mxBeanMethod.invoke(mgmtFactory, new Object[0]);
                if (this.mxBean == null) {
                    throw new UnsupportedOperationException("getRuntimeMXBean() method returned null");
                }
                this.uptimeMethod = runtimeClass.getMethod("getUptime", noparams);
                if (this.mxBean == null) {
                    throw new UnsupportedOperationException("method getUptime() not found");
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoClassDefFoundError | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
                throw new UnsupportedOperationException("Implementation not available in this environment", e2);
            }
        }

        @Override
        public long getUptime() {
            try {
                return (Long)this.uptimeMethod.invoke(this.mxBean, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e2) {
                return -1L;
            }
        }
    }

    public static interface Impl {
        public long getUptime();
    }
}

