/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.HostPort;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.TypeUtil;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.Utf8Appendable;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.Utf8StringBuilder;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class URIUtil
implements Cloneable {
    private static final Logger LOG = Log.getLogger(URIUtil.class);
    public static final Charset __CHARSET = StandardCharsets.UTF_8;

    private URIUtil() {
    }

    public static String decodePath(String path) {
        return URIUtil.decodePath(path, 0, path.length());
    }

    public static String decodePath(String path, int offset, int length) {
        try {
            Utf8StringBuilder builder = null;
            int end = offset + length;
            block8: for (int i2 = offset; i2 < end; ++i2) {
                char c2 = path.charAt(i2);
                switch (c2) {
                    case '%': {
                        if (builder == null) {
                            builder = new Utf8StringBuilder(path.length());
                            builder.append(path, offset, i2 - offset);
                        }
                        if (i2 + 2 < end) {
                            char u2 = path.charAt(i2 + 1);
                            if (u2 == 'u') {
                                builder.append((char)(0xFFFF & TypeUtil.parseInt(path, i2 + 2, 4, 16)));
                                i2 += 5;
                                continue block8;
                            }
                            builder.append((byte)(0xFF & TypeUtil.convertHexDigit(u2) * 16 + TypeUtil.convertHexDigit(path.charAt(i2 + 2))));
                            i2 += 2;
                            continue block8;
                        }
                        throw new IllegalArgumentException("Bad URI % encoding");
                    }
                    case ';': {
                        if (builder == null) {
                            builder = new Utf8StringBuilder(path.length());
                            builder.append(path, offset, i2 - offset);
                        }
                        while (++i2 < end) {
                            if (path.charAt(i2) != '/') continue;
                            builder.append('/');
                            continue block8;
                        }
                        continue block8;
                    }
                    default: {
                        if (builder == null) continue block8;
                        builder.append(c2);
                    }
                }
            }
            if (builder != null) {
                return builder.toString();
            }
            if (offset == 0 && length == path.length()) {
                return path;
            }
            return path.substring(offset, end);
        }
        catch (Utf8Appendable.NotUtf8Exception e2) {
            LOG.debug(path.substring(offset, offset + length) + " " + e2, new Object[0]);
            return URIUtil.decodeISO88591Path(path, offset, length);
        }
        catch (IllegalArgumentException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw new IllegalArgumentException("cannot decode URI", e4);
        }
    }

    private static String decodeISO88591Path(String path, int offset, int length) {
        StringBuilder builder = null;
        int end = offset + length;
        block4: for (int i2 = offset; i2 < end; ++i2) {
            char c2 = path.charAt(i2);
            switch (c2) {
                case '%': {
                    if (builder == null) {
                        builder = new StringBuilder(path.length());
                        builder.append(path, offset, i2 - offset);
                    }
                    if (i2 + 2 < end) {
                        char u2 = path.charAt(i2 + 1);
                        if (u2 == 'u') {
                            builder.append((char)(0xFFFF & TypeUtil.parseInt(path, i2 + 2, 4, 16)));
                            i2 += 5;
                            continue block4;
                        }
                        builder.append((char)(0xFF & TypeUtil.convertHexDigit(u2) * 16 + TypeUtil.convertHexDigit(path.charAt(i2 + 2))));
                        i2 += 2;
                        continue block4;
                    }
                    throw new IllegalArgumentException();
                }
                case ';': {
                    if (builder == null) {
                        builder = new StringBuilder(path.length());
                        builder.append(path, offset, i2 - offset);
                    }
                    while (++i2 < end) {
                        if (path.charAt(i2) != '/') continue;
                        builder.append('/');
                        continue block4;
                    }
                    continue block4;
                }
                default: {
                    if (builder == null) continue block4;
                    builder.append(c2);
                }
            }
        }
        if (builder != null) {
            return builder.toString();
        }
        if (offset == 0 && length == path.length()) {
            return path;
        }
        return path.substring(offset, end);
    }

    public static String canonicalPath(String path) {
        int i2;
        if (path == null || path.isEmpty()) {
            return path;
        }
        boolean slash = true;
        int end = path.length();
        block8: for (i2 = 0; i2 < end; ++i2) {
            char c2 = path.charAt(i2);
            switch (c2) {
                case '/': {
                    slash = true;
                    continue block8;
                }
                case '.': {
                    if (slash) break block8;
                    slash = false;
                    continue block8;
                }
                default: {
                    slash = false;
                }
            }
        }
        if (i2 == end) {
            return path;
        }
        StringBuilder canonical = new StringBuilder(path.length());
        canonical.append(path, 0, i2);
        int dots = 1;
        ++i2;
        while (i2 < end) {
            char c3 = path.charAt(i2);
            switch (c3) {
                case '/': {
                    if (URIUtil.doDotsSlash(canonical, dots)) {
                        return null;
                    }
                    slash = true;
                    dots = 0;
                    break;
                }
                case '.': {
                    if (dots > 0) {
                        ++dots;
                    } else if (slash) {
                        dots = 1;
                    } else {
                        canonical.append('.');
                    }
                    slash = false;
                    break;
                }
                default: {
                    while (dots-- > 0) {
                        canonical.append('.');
                    }
                    canonical.append(c3);
                    dots = 0;
                    slash = false;
                }
            }
            ++i2;
        }
        if (URIUtil.doDots(canonical, dots)) {
            return null;
        }
        return canonical.toString();
    }

    private static boolean doDots(StringBuilder canonical, int dots) {
        switch (dots) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (canonical.length() < 2) {
                    return true;
                }
                canonical.setLength(canonical.length() - 1);
                canonical.setLength(canonical.lastIndexOf("/") + 1);
                break;
            }
            default: {
                while (dots-- > 0) {
                    canonical.append('.');
                }
                break block0;
            }
        }
        return false;
    }

    private static boolean doDotsSlash(StringBuilder canonical, int dots) {
        switch (dots) {
            case 0: {
                canonical.append('/');
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (canonical.length() < 2) {
                    return true;
                }
                canonical.setLength(canonical.length() - 1);
                canonical.setLength(canonical.lastIndexOf("/") + 1);
                break;
            }
            default: {
                while (dots-- > 0) {
                    canonical.append('.');
                }
                canonical.append('/');
            }
        }
        return false;
    }

    public static void appendSchemeHostPort(StringBuilder url, String scheme, String server, int port) {
        url.append(scheme).append("://").append(HostPort.normalizeHost(server));
        if (port > 0) {
            switch (scheme) {
                case "http": {
                    if (port == 80) break;
                    url.append(':').append(port);
                    break;
                }
                case "https": {
                    if (port == 443) break;
                    url.append(':').append(port);
                    break;
                }
                default: {
                    url.append(':').append(port);
                }
            }
        }
    }

    public static boolean equalsIgnoreEncodings(String uriA, String uriB) {
        int lenA = uriA.length();
        int lenB = uriB.length();
        int a2 = 0;
        int b2 = 0;
        while (a2 < lenA && b2 < lenB) {
            int ob;
            int cb;
            int oa;
            int ca;
            if ((ca = (oa = uriA.charAt(a2++))) == 37) {
                ca = URIUtil.lenientPercentDecode(uriA, a2);
                if (ca == -1) {
                    ca = 37;
                } else {
                    a2 += 2;
                }
            }
            if ((cb = (ob = uriB.charAt(b2++))) == 37) {
                cb = URIUtil.lenientPercentDecode(uriB, b2);
                if (cb == -1) {
                    cb = 37;
                } else {
                    b2 += 2;
                }
            }
            if (ca == 47 && oa != ob) {
                return false;
            }
            if (ca == cb) continue;
            return false;
        }
        return a2 == lenA && b2 == lenB;
    }

    private static int lenientPercentDecode(String str, int offset) {
        if (offset >= str.length()) {
            return -1;
        }
        if (StringUtil.isHex(str, offset, 2)) {
            return TypeUtil.parseInt(str, offset, 2, 16);
        }
        return -1;
    }

    public static boolean equalsIgnoreEncodings(URI uriA, URI uriB) {
        if (uriA.equals(uriB)) {
            return true;
        }
        if (uriA.getScheme() == null ? uriB.getScheme() != null : !uriA.getScheme().equalsIgnoreCase(uriB.getScheme())) {
            return false;
        }
        if ("jar".equalsIgnoreCase(uriA.getScheme())) {
            URI uriAssp = URI.create(uriA.getSchemeSpecificPart());
            URI uriBssp = URI.create(uriB.getSchemeSpecificPart());
            return URIUtil.equalsIgnoreEncodings(uriAssp, uriBssp);
        }
        if (uriA.getAuthority() == null ? uriB.getAuthority() != null : !uriA.getAuthority().equals(uriB.getAuthority())) {
            return false;
        }
        return URIUtil.equalsIgnoreEncodings(uriA.getPath(), uriB.getPath());
    }
}

