/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.AtomicBiInteger;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.IO;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.component.Dumpable;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.component.DumpableCollection;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.thread.Locker;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public class Pool<T>
implements AutoCloseable,
Dumpable {
    private static final Logger LOGGER = Log.getLogger(Pool.class);
    private final List<Entry> entries = new CopyOnWriteArrayList<Entry>();
    private final int maxEntries;
    private final StrategyType strategyType;
    private final Locker locker = new Locker();
    private final ThreadLocal<Entry> cache;
    private final AtomicInteger nextIndex;
    private volatile boolean closed;
    @Deprecated
    private volatile int maxUsage = -1;
    @Deprecated
    private volatile int maxMultiplex = -1;

    public Pool(StrategyType strategyType, int maxEntries, boolean cache) {
        this.maxEntries = maxEntries;
        this.strategyType = strategyType;
        this.cache = cache ? new ThreadLocal() : null;
        this.nextIndex = strategyType == StrategyType.ROUND_ROBIN ? new AtomicInteger() : null;
    }

    public int getIdleCount() {
        return (int)this.entries.stream().filter(Entry::isIdle).count();
    }

    public int getInUseCount() {
        return (int)this.entries.stream().filter(Entry::isInUse).count();
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    @Deprecated
    public int getMaxMultiplex() {
        return this.maxMultiplex == -1 ? 1 : this.maxMultiplex;
    }

    @Deprecated
    protected int getMaxMultiplex(T pooled) {
        return this.getMaxMultiplex();
    }

    @Deprecated
    public final void setMaxMultiplex(int maxMultiplex) {
        if (maxMultiplex < 1) {
            throw new IllegalArgumentException("Max multiplex must be >= 1");
        }
        try (Locker.Lock l2 = this.locker.lock();){
            if (this.closed) {
                return;
            }
            if (this.entries.stream().anyMatch(MonoEntry.class::isInstance)) {
                throw new IllegalStateException("Pool entries do not support multiplexing");
            }
            this.maxMultiplex = maxMultiplex;
        }
    }

    @Deprecated
    public int getMaxUsageCount() {
        return this.maxUsage;
    }

    @Deprecated
    protected int getMaxUsageCount(T pooled) {
        return this.getMaxUsageCount();
    }

    public Entry reserve() {
        try (Locker.Lock l2 = this.locker.lock();){
            if (this.closed) {
                Entry entry = null;
                return entry;
            }
            if (this.entries.size() >= this.maxEntries) {
                Entry entry = null;
                return entry;
            }
            Entry entry = this.newEntry();
            this.entries.add(entry);
            Entry entry2 = entry;
            return entry2;
        }
    }

    private Entry newEntry() {
        if (this.maxMultiplex >= 0 || this.maxUsage >= 0) {
            return new MultiEntry();
        }
        return new MonoEntry();
    }

    public Entry acquire() {
        Entry entry;
        if (this.closed) {
            return null;
        }
        int size = this.entries.size();
        if (size == 0) {
            return null;
        }
        if (this.cache != null && (entry = this.cache.get()) != null && entry.tryAcquire()) {
            return entry;
        }
        int index = this.startIndex(size);
        int tries = size;
        while (tries-- > 0) {
            try {
                Entry entry2 = this.entries.get(index);
                if (entry2 != null && entry2.tryAcquire()) {
                    return entry2;
                }
            }
            catch (IndexOutOfBoundsException e2) {
                LOGGER.ignore(e2);
                size = this.entries.size();
                if (size == 0) break;
            }
            index = (index + 1) % size;
        }
        return null;
    }

    private int startIndex(int size) {
        switch (this.strategyType) {
            case FIRST: {
                return 0;
            }
            case RANDOM: {
                return ThreadLocalRandom.current().nextInt(size);
            }
            case ROUND_ROBIN: {
                return this.nextIndex.getAndUpdate(c2 -> Math.max(0, c2 + 1)) % size;
            }
            case THREAD_ID: {
                return (int)(Thread.currentThread().getId() % (long)size);
            }
        }
        throw new IllegalArgumentException("Unknown strategy type: " + (Object)((Object)this.strategyType));
    }

    public boolean release(Entry entry) {
        if (this.closed) {
            return false;
        }
        boolean released = entry.tryRelease();
        if (released && this.cache != null) {
            this.cache.set(entry);
        }
        return released;
    }

    public boolean remove(Entry entry) {
        if (this.closed) {
            return false;
        }
        if (!entry.tryRemove()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Attempt to remove an object from the pool that is still in use: {}", entry);
            }
            return false;
        }
        boolean removed = this.entries.remove(entry);
        if (!removed && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Attempt to remove an object from the pool that does not exist: {}", entry);
        }
        return removed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        ArrayList<Entry> copy;
        try (Locker.Lock l2 = this.locker.lock();){
            this.closed = true;
            copy = new ArrayList<Entry>(this.entries);
            this.entries.clear();
        }
        for (Entry entry : copy) {
            boolean removed = entry.tryRemove();
            if (removed) {
                if (!(entry.pooled instanceof Closeable)) continue;
                IO.close((Closeable)entry.pooled);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Pooled object still in use: {}", entry);
        }
    }

    public int size() {
        return this.entries.size();
    }

    public Collection<Entry> values() {
        return Collections.unmodifiableCollection(this.entries);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, new DumpableCollection("entries", this.entries));
    }

    public String toString() {
        return String.format("%s@%x[inUse=%d,size=%d,capacity=%d,closed=%b]", this.getClass().getSimpleName(), this.hashCode(), this.getInUseCount(), this.size(), this.getMaxEntries(), this.isClosed());
    }

    class MultiEntry
    extends Entry {
        private final AtomicBiInteger state;

        MultiEntry() {
            this.state = new AtomicBiInteger(Integer.MIN_VALUE, 0);
        }

        @Override
        protected boolean tryEnable(boolean acquire) {
            int usage = acquire ? 1 : 0;
            return this.state.compareAndSet(Integer.MIN_VALUE, usage, 0, usage);
        }

        @Override
        boolean tryAcquire() {
            int multiplexCount;
            int usageCount;
            int newUsageCount;
            long encoded;
            do {
                boolean closed;
                encoded = this.state.get();
                usageCount = AtomicBiInteger.getHi(encoded);
                multiplexCount = AtomicBiInteger.getLo(encoded);
                boolean bl = closed = usageCount < 0;
                if (closed) {
                    return false;
                }
                Object pooled = this.getPooled();
                int maxUsageCount = Pool.this.getMaxUsageCount(pooled);
                int maxMultiplexed = Pool.this.getMaxMultiplex(pooled);
                if (maxMultiplexed > 0 && multiplexCount >= maxMultiplexed) {
                    return false;
                }
                if (maxUsageCount <= 0 || usageCount < maxUsageCount) continue;
                return false;
            } while (!this.state.compareAndSet(encoded, newUsageCount = usageCount == Integer.MAX_VALUE ? Integer.MAX_VALUE : usageCount + 1, multiplexCount + 1));
            return true;
        }

        @Override
        boolean tryRelease() {
            int newMultiplexCount;
            int usageCount;
            long encoded;
            do {
                boolean closed;
                boolean bl = closed = (usageCount = AtomicBiInteger.getHi(encoded = this.state.get())) < 0;
                if (closed) {
                    return false;
                }
                newMultiplexCount = AtomicBiInteger.getLo(encoded) - 1;
                if (newMultiplexCount >= 0) continue;
                throw new IllegalStateException("Cannot release an already released entry");
            } while (!this.state.compareAndSet(encoded, usageCount, newMultiplexCount));
            int currentMaxUsageCount = Pool.this.maxUsage;
            boolean overUsed = currentMaxUsageCount > 0 && usageCount >= currentMaxUsageCount;
            return !overUsed || newMultiplexCount != 0;
        }

        @Override
        boolean tryRemove() {
            int newMultiplexCount;
            int multiplexCount;
            long encoded;
            int usageCount;
            boolean removed;
            while (!(removed = this.state.compareAndSet(usageCount = AtomicBiInteger.getHi(encoded = this.state.get()), -1, multiplexCount = AtomicBiInteger.getLo(encoded), newMultiplexCount = Math.max(multiplexCount - 1, 0)))) {
            }
            return newMultiplexCount == 0;
        }

        @Override
        public boolean isClosed() {
            return this.state.getHi() < 0;
        }

        @Override
        public boolean isReserved() {
            return this.state.getHi() == Integer.MIN_VALUE;
        }

        @Override
        public boolean isIdle() {
            long encoded = this.state.get();
            return AtomicBiInteger.getHi(encoded) >= 0 && AtomicBiInteger.getLo(encoded) == 0;
        }

        @Override
        public boolean isInUse() {
            long encoded = this.state.get();
            return AtomicBiInteger.getHi(encoded) >= 0 && AtomicBiInteger.getLo(encoded) > 0;
        }

        public String toString() {
            long encoded = this.state.get();
            int usageCount = AtomicBiInteger.getHi(encoded);
            int multiplexCount = AtomicBiInteger.getLo(encoded);
            String state = usageCount < 0 ? (usageCount == Integer.MIN_VALUE ? "PENDING" : "CLOSED") : (multiplexCount == 0 ? "IDLE" : "ACTIVE");
            return String.format("%s@%x{%s,usage=%d,multiplex=%d,pooled=%s}", this.getClass().getSimpleName(), this.hashCode(), state, Math.max(usageCount, 0), Math.max(multiplexCount, 0), this.getPooled());
        }
    }

    private class MonoEntry
    extends Entry {
        private final AtomicInteger state;

        private MonoEntry() {
            this.state = new AtomicInteger(Integer.MIN_VALUE);
        }

        @Override
        protected boolean tryEnable(boolean acquire) {
            return this.state.compareAndSet(Integer.MIN_VALUE, acquire ? 1 : 0);
        }

        @Override
        boolean tryAcquire() {
            int s2;
            do {
                if ((s2 = this.state.get()) == 0) continue;
                return false;
            } while (!this.state.compareAndSet(s2, 1));
            return true;
        }

        @Override
        boolean tryRelease() {
            int s2;
            do {
                if ((s2 = this.state.get()) < 0) {
                    return false;
                }
                if (s2 != 0) continue;
                throw new IllegalStateException("Cannot release an already released entry");
            } while (!this.state.compareAndSet(s2, 0));
            return true;
        }

        @Override
        boolean tryRemove() {
            this.state.set(-1);
            return true;
        }

        @Override
        public boolean isClosed() {
            return this.state.get() < 0;
        }

        @Override
        public boolean isReserved() {
            return this.state.get() == Integer.MIN_VALUE;
        }

        @Override
        public boolean isIdle() {
            return this.state.get() == 0;
        }

        @Override
        public boolean isInUse() {
            return this.state.get() == 1;
        }

        public String toString() {
            String s2;
            switch (this.state.get()) {
                case -2147483648: {
                    s2 = "PENDING";
                    break;
                }
                case -1: {
                    s2 = "CLOSED";
                    break;
                }
                case 0: {
                    s2 = "IDLE";
                    break;
                }
                default: {
                    s2 = "ACTIVE";
                }
            }
            return String.format("%s@%x{%s,pooled=%s}", this.getClass().getSimpleName(), this.hashCode(), s2, this.getPooled());
        }
    }

    public abstract class Entry {
        private T pooled;

        public boolean enable(T pooled, boolean acquire) {
            Objects.requireNonNull(pooled);
            if (!this.isReserved()) {
                if (this.isClosed()) {
                    return false;
                }
                throw new IllegalStateException("Entry already enabled: " + this);
            }
            this.pooled = pooled;
            if (this.tryEnable(acquire)) {
                return true;
            }
            this.pooled = null;
            if (this.isClosed()) {
                return false;
            }
            throw new IllegalStateException("Entry already enabled: " + this);
        }

        public T getPooled() {
            return this.pooled;
        }

        public boolean remove() {
            return Pool.this.remove(this);
        }

        abstract boolean tryEnable(boolean var1);

        abstract boolean tryAcquire();

        abstract boolean tryRelease();

        abstract boolean tryRemove();

        public abstract boolean isClosed();

        public abstract boolean isReserved();

        public abstract boolean isIdle();

        public abstract boolean isInUse();
    }

    public static enum StrategyType {
        FIRST,
        RANDOM,
        THREAD_ID,
        ROUND_ROBIN;

    }
}

