/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.BufferUtil;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public class RetainableByteBuffer {
    private final ByteBufferPool pool;
    private final ByteBuffer buffer;
    private final AtomicInteger references;

    public RetainableByteBuffer(ByteBufferPool pool, int size, boolean direct) {
        this.pool = pool;
        this.buffer = pool.acquire(size, direct);
        this.references = new AtomicInteger(1);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getReferences() {
        return this.references.get();
    }

    public void retain() {
        int r2;
        do {
            if ((r2 = this.references.get()) != 0) continue;
            throw new IllegalStateException("released " + this);
        } while (!this.references.compareAndSet(r2, r2 + 1));
    }

    public int release() {
        int ref = this.references.decrementAndGet();
        if (ref == 0) {
            this.pool.release(this.buffer);
        } else if (ref < 0) {
            throw new IllegalStateException("already released " + this);
        }
        return ref;
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public boolean isEmpty() {
        return !this.hasRemaining();
    }

    public void clear() {
        BufferUtil.clear(this.buffer);
    }

    public String toString() {
        return String.format("%s@%x{%s,r=%d}", this.getClass().getSimpleName(), this.hashCode(), BufferUtil.toDetailString(this.buffer), this.getReferences());
    }
}

