/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.NullByteBufferPool;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.BufferUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ByteBufferAccumulator
implements AutoCloseable {
    private final List<ByteBuffer> _buffers = new ArrayList<ByteBuffer>();
    private final ByteBufferPool _bufferPool;
    private final boolean _direct;

    public ByteBufferAccumulator() {
        this(null, false);
    }

    public ByteBufferAccumulator(ByteBufferPool bufferPool, boolean direct) {
        this._bufferPool = bufferPool == null ? new NullByteBufferPool() : bufferPool;
        this._direct = direct;
    }

    public int getLength() {
        int length = 0;
        for (ByteBuffer buffer : this._buffers) {
            length = Math.addExact(length, buffer.remaining());
        }
        return length;
    }

    public ByteBuffer ensureBuffer(int minSize, int minAllocationSize) {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = this._buffers.isEmpty() ? BufferUtil.EMPTY_BUFFER : this._buffers.get(this._buffers.size() - 1);
        if (BufferUtil.space(buffer) < minSize) {
            buffer = this._bufferPool.acquire(minAllocationSize, this._direct);
            this._buffers.add(buffer);
        }
        return buffer;
    }

    public ByteBuffer takeByteBuffer() {
        if (this._buffers.size() == 1) {
            ByteBuffer combinedBuffer = this._buffers.get(0);
            this._buffers.clear();
            return combinedBuffer;
        }
        int length = this.getLength();
        ByteBuffer combinedBuffer = this._bufferPool.acquire(length, this._direct);
        BufferUtil.clearToFill(combinedBuffer);
        for (ByteBuffer buffer : this._buffers) {
            combinedBuffer.put(buffer);
            this._bufferPool.release(buffer);
        }
        BufferUtil.flipToFlush(combinedBuffer, 0);
        this._buffers.clear();
        return combinedBuffer;
    }

    @Override
    public void close() {
        this._buffers.forEach(this._bufferPool::release);
        this._buffers.clear();
    }
}

