/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.BadMessageException;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.HttpFields;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.HttpHeaderValue;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.HttpMethod;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.HttpStatus;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.HttpTokens;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.HttpVersion;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.MetaData;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.PreEncodedHttpField;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.ArrayTrie;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.Trie;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HttpGenerator {
    private static final Logger LOG = Log.getLogger(HttpGenerator.class);
    public static final boolean __STRICT = Boolean.getBoolean("com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.HttpGenerator.STRICT");
    private static final byte[] __colon_space = new byte[]{58, 32};
    public static final MetaData.Response CONTINUE_100_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 100, null, null, -1L);
    public static final MetaData.Response PROGRESS_102_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 102, null, null, -1L);
    public static final MetaData.Response RESPONSE_500_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 500, null, new HttpFields(){
        {
            this.put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
        }
    }, 0L);
    private State _state = State.START;
    private HttpTokens.EndOfContent _endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
    private long _contentPrepared = 0L;
    private boolean _noContentResponse = false;
    private Boolean _persistent = null;
    private Supplier<HttpFields> _trailers = null;
    private final int _send;
    private static final Trie<Boolean> ASSUMED_CONTENT_METHODS = new ArrayTrie<Boolean>(8);
    private boolean _needCRLF = false;
    private static final byte[] ZERO_CHUNK;
    private static final byte[] LAST_CHUNK;
    private static final byte[] CONTENT_LENGTH_0;
    private static final byte[] CONNECTION_CLOSE;
    private static final byte[] HTTP_1_1_SPACE;
    private static final byte[] TRANSFER_ENCODING_CHUNKED;
    private static final byte[][] SEND;
    private static final PreparedResponse[] __preprepared;

    public HttpGenerator() {
        this(false, false);
    }

    public HttpGenerator(boolean sendServerVersion, boolean sendXPoweredBy) {
        this._send = (sendServerVersion ? 1 : 0) | (sendXPoweredBy ? 2 : 0);
    }

    public void reset() {
        this._state = State.START;
        this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
        this._noContentResponse = false;
        this._persistent = null;
        this._contentPrepared = 0L;
        this._needCRLF = false;
        this._trailers = null;
    }

    public boolean isChunking() {
        return this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT;
    }

    public void abort() {
        this._persistent = false;
        this._state = State.END;
        this._endOfContent = null;
    }

    public Result generateRequest(MetaData.Request info, ByteBuffer header, ByteBuffer chunk, ByteBuffer content, boolean last) throws IOException {
        switch (this._state) {
            case START: {
                if (info == null) {
                    return Result.NEED_INFO;
                }
                if (header == null) {
                    return Result.NEED_HEADER;
                }
                int pos = BufferUtil.flipToFill(header);
                try {
                    this.generateRequestLine(info, header);
                    if (info.getHttpVersion() == HttpVersion.HTTP_0_9) {
                        throw new BadMessageException(500, "HTTP/0.9 not supported");
                    }
                    this.generateHeaders(info, header, content, last);
                    boolean expect100 = info.getFields().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
                    if (expect100) {
                        this._state = State.COMMITTED;
                    } else {
                        int len = BufferUtil.length(content);
                        if (len > 0) {
                            this._contentPrepared += (long)len;
                            if (this.isChunking()) {
                                this.prepareChunk(header, len);
                            }
                        }
                        this._state = last ? State.COMPLETING : State.COMMITTED;
                    }
                    Result result = Result.FLUSH;
                    return result;
                }
                catch (BadMessageException e2) {
                    throw e2;
                }
                catch (BufferOverflowException e3) {
                    LOG.ignore(e3);
                    Result result = Result.HEADER_OVERFLOW;
                    return result;
                }
                catch (Exception e4) {
                    throw new BadMessageException(500, e4.getMessage(), e4);
                }
                finally {
                    BufferUtil.flipToFlush(header, pos);
                }
            }
            case COMMITTED: {
                return this.committed(chunk, content, last);
            }
            case COMPLETING: {
                return this.completing(chunk, content);
            }
            case END: {
                if (BufferUtil.hasContent(content)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("discarding content in COMPLETING", new Object[0]);
                    }
                    BufferUtil.clear(content);
                }
                return Result.DONE;
            }
        }
        throw new IllegalStateException();
    }

    private Result committed(ByteBuffer chunk, ByteBuffer content, boolean last) {
        int len = BufferUtil.length(content);
        if (len > 0) {
            if (this.isChunking()) {
                if (chunk == null) {
                    return Result.NEED_CHUNK;
                }
                BufferUtil.clearToFill(chunk);
                this.prepareChunk(chunk, len);
                BufferUtil.flipToFlush(chunk, 0);
            }
            this._contentPrepared += (long)len;
        }
        if (last) {
            this._state = State.COMPLETING;
            return len > 0 ? Result.FLUSH : Result.CONTINUE;
        }
        return len > 0 ? Result.FLUSH : Result.DONE;
    }

    private Result completing(ByteBuffer chunk, ByteBuffer content) {
        if (BufferUtil.hasContent(content)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("discarding content in COMPLETING", new Object[0]);
            }
            BufferUtil.clear(content);
        }
        if (this.isChunking()) {
            if (this._trailers != null) {
                if (chunk == null || chunk.capacity() <= 12) {
                    return Result.NEED_CHUNK_TRAILER;
                }
                HttpFields trailers = this._trailers.get();
                if (trailers != null) {
                    BufferUtil.clearToFill(chunk);
                    this.generateTrailers(chunk, trailers);
                    BufferUtil.flipToFlush(chunk, 0);
                    this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
                    return Result.FLUSH;
                }
            }
            if (chunk == null) {
                return Result.NEED_CHUNK;
            }
            BufferUtil.clearToFill(chunk);
            this.prepareChunk(chunk, 0);
            BufferUtil.flipToFlush(chunk, 0);
            this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
            return Result.FLUSH;
        }
        this._state = State.END;
        return Boolean.TRUE.equals(this._persistent) ? Result.DONE : Result.SHUTDOWN_OUT;
    }

    private void prepareChunk(ByteBuffer chunk, int remaining) {
        if (this._needCRLF) {
            BufferUtil.putCRLF(chunk);
        }
        if (remaining > 0) {
            BufferUtil.putHexInt(chunk, remaining);
            BufferUtil.putCRLF(chunk);
            this._needCRLF = true;
        } else {
            chunk.put(LAST_CHUNK);
            this._needCRLF = false;
        }
    }

    private void generateTrailers(ByteBuffer buffer, HttpFields trailer) {
        if (this._needCRLF) {
            BufferUtil.putCRLF(buffer);
        }
        buffer.put(ZERO_CHUNK);
        int n2 = trailer.size();
        for (int f2 = 0; f2 < n2; ++f2) {
            HttpField field = trailer.getField(f2);
            HttpGenerator.putTo(field, buffer);
        }
        BufferUtil.putCRLF(buffer);
    }

    private void generateRequestLine(MetaData.Request request, ByteBuffer header) {
        header.put(StringUtil.getBytes(request.getMethod()));
        header.put((byte)32);
        header.put(StringUtil.getBytes(request.getURIString()));
        header.put((byte)32);
        header.put(request.getHttpVersion().toBytes());
        header.put(HttpTokens.CRLF);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateHeaders(MetaData info, ByteBuffer header, ByteBuffer content, boolean last) {
        int status;
        boolean nocontentRequest;
        MetaData.Response response;
        MetaData.Request request = info instanceof MetaData.Request ? (MetaData.Request)info : null;
        MetaData.Response response2 = response = info instanceof MetaData.Response ? (MetaData.Response)info : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("generateHeaders {} last={} content={}", info, last, BufferUtil.toDetailString(content));
            LOG.debug(info.getFields().toString(), new Object[0]);
        }
        int send = this._send;
        HttpField transferEncoding = null;
        boolean http11 = info.getHttpVersion() == HttpVersion.HTTP_1_1;
        boolean close = false;
        this._trailers = http11 ? info.getTrailerSupplier() : null;
        boolean chunkedHint = this._trailers != null;
        boolean contentType = false;
        long contentLength = info.getContentLength();
        boolean contentLengthField = false;
        HttpFields fields = info.getFields();
        if (fields != null) {
            int n2 = fields.size();
            block7: for (int f2 = 0; f2 < n2; ++f2) {
                HttpField field = fields.getField(f2);
                HttpHeader h2 = field.getHeader();
                if (h2 == null) {
                    HttpGenerator.putTo(field, header);
                    continue;
                }
                switch (h2) {
                    case CONTENT_LENGTH: {
                        if (contentLength < 0L) {
                            contentLength = field.getLongValue();
                        } else if (contentLength != field.getLongValue()) {
                            throw new BadMessageException(500, String.format("Incorrect Content-Length %d!=%d", contentLength, field.getLongValue()));
                        }
                        contentLengthField = true;
                        continue block7;
                    }
                    case CONTENT_TYPE: {
                        contentType = true;
                        HttpGenerator.putTo(field, header);
                        continue block7;
                    }
                    case TRANSFER_ENCODING: {
                        if (!http11) continue block7;
                        transferEncoding = field;
                        chunkedHint = field.contains(HttpHeaderValue.CHUNKED.asString());
                        continue block7;
                    }
                    case CONNECTION: {
                        boolean keepAlive = field.contains(HttpHeaderValue.KEEP_ALIVE.asString());
                        if (keepAlive && info.getHttpVersion() == HttpVersion.HTTP_1_0 && this._persistent == null) {
                            this._persistent = true;
                        }
                        if (field.contains(HttpHeaderValue.CLOSE.asString())) {
                            close = true;
                            this._persistent = false;
                        }
                        if (keepAlive && Boolean.FALSE.equals(this._persistent)) {
                            field = new HttpField(HttpHeader.CONNECTION, Stream.of(field.getValues()).filter(s2 -> !HttpHeaderValue.KEEP_ALIVE.is((String)s2)).collect(Collectors.joining(", ")));
                        }
                        HttpGenerator.putTo(field, header);
                        continue block7;
                    }
                    case SERVER: {
                        send &= 0xFFFFFFFE;
                        HttpGenerator.putTo(field, header);
                        continue block7;
                    }
                    default: {
                        HttpGenerator.putTo(field, header);
                    }
                }
            }
        }
        if (last && contentLength < 0L && this._trailers == null) {
            contentLength = this._contentPrepared + (long)BufferUtil.length(content);
        }
        boolean assumedContentRequest = request != null && Boolean.TRUE.equals(ASSUMED_CONTENT_METHODS.get(request.getMethod()));
        boolean assumedContent = assumedContentRequest || contentType || chunkedHint;
        boolean bl = nocontentRequest = request != null && contentLength <= 0L && !assumedContent;
        if (this._persistent == null) {
            this._persistent = http11 || request != null && HttpMethod.CONNECT.is(request.getMethod());
        }
        if (this._noContentResponse || nocontentRequest) {
            this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
            if (this._contentPrepared > 0L) {
                throw new BadMessageException(500, "Content for no content response");
            }
            if (contentLengthField) {
                if (response != null && response.getStatus() == 304) {
                    HttpGenerator.putContentLength(header, contentLength);
                } else if (contentLength > 0L) {
                    if (this._contentPrepared != 0L || !last) throw new BadMessageException(500, "Content for no content response");
                    content.clear();
                }
            }
        } else if (http11 && (chunkedHint || contentLength < 0L && (this._persistent.booleanValue() || assumedContentRequest))) {
            this._endOfContent = HttpTokens.EndOfContent.CHUNKED_CONTENT;
            if (transferEncoding == null) {
                header.put(TRANSFER_ENCODING_CHUNKED);
            } else if (transferEncoding.toString().endsWith(HttpHeaderValue.CHUNKED.toString())) {
                HttpGenerator.putTo(transferEncoding, header);
                transferEncoding = null;
            } else {
                if (chunkedHint) throw new BadMessageException(500, "Bad Transfer-Encoding");
                HttpGenerator.putTo(new HttpField(HttpHeader.TRANSFER_ENCODING, transferEncoding.getValue() + ",chunked"), header);
                transferEncoding = null;
            }
        } else if (contentLength >= 0L && (request != null || this._persistent.booleanValue())) {
            this._endOfContent = HttpTokens.EndOfContent.CONTENT_LENGTH;
            HttpGenerator.putContentLength(header, contentLength);
        } else {
            if (response == null) throw new BadMessageException(500, "Unknown content length for request");
            this._endOfContent = HttpTokens.EndOfContent.EOF_CONTENT;
            this._persistent = false;
            if (contentLength >= 0L && (contentLength > 0L || assumedContent || contentLengthField)) {
                HttpGenerator.putContentLength(header, contentLength);
            }
            if (http11 && !close) {
                header.put(CONNECTION_CLOSE);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this._endOfContent.toString(), new Object[0]);
        }
        if (transferEncoding != null) {
            if (chunkedHint) {
                String v2 = transferEncoding.getValue();
                int c2 = v2.lastIndexOf(44);
                if (c2 > 0 && v2.lastIndexOf(HttpHeaderValue.CHUNKED.toString(), c2) > c2) {
                    HttpGenerator.putTo(new HttpField(HttpHeader.TRANSFER_ENCODING, v2.substring(0, c2).trim()), header);
                }
            } else {
                HttpGenerator.putTo(transferEncoding, header);
            }
        }
        int n3 = status = response != null ? response.getStatus() : -1;
        if (status > 199) {
            header.put(SEND[send]);
        }
        header.put(HttpTokens.CRLF);
    }

    private static void putContentLength(ByteBuffer header, long contentLength) {
        if (contentLength == 0L) {
            header.put(CONTENT_LENGTH_0);
        } else {
            header.put(HttpHeader.CONTENT_LENGTH.getBytesColonSpace());
            BufferUtil.putDecLong(header, contentLength);
            header.put(HttpTokens.CRLF);
        }
    }

    public String toString() {
        return String.format("%s@%x{s=%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state});
    }

    private static void putSanitisedName(String s2, ByteBuffer buffer) {
        int l2 = s2.length();
        for (int i2 = 0; i2 < l2; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 < '\u0000' || c2 > '\u00ff' || c2 == '\r' || c2 == '\n' || c2 == ':') {
                buffer.put((byte)63);
                continue;
            }
            buffer.put((byte)(0xFF & c2));
        }
    }

    private static void putSanitisedValue(String s2, ByteBuffer buffer) {
        int l2 = s2.length();
        for (int i2 = 0; i2 < l2; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 < '\u0000' || c2 > '\u00ff' || c2 == '\r' || c2 == '\n') {
                buffer.put((byte)32);
                continue;
            }
            buffer.put((byte)(0xFF & c2));
        }
    }

    public static void putTo(HttpField field, ByteBuffer bufferInFillMode) {
        if (field instanceof PreEncodedHttpField) {
            ((PreEncodedHttpField)field).putTo(bufferInFillMode, HttpVersion.HTTP_1_0);
        } else {
            HttpHeader header = field.getHeader();
            if (header != null) {
                bufferInFillMode.put(header.getBytesColonSpace());
                HttpGenerator.putSanitisedValue(field.getValue(), bufferInFillMode);
            } else {
                HttpGenerator.putSanitisedName(field.getName(), bufferInFillMode);
                bufferInFillMode.put(__colon_space);
                HttpGenerator.putSanitisedValue(field.getValue(), bufferInFillMode);
            }
            BufferUtil.putCRLF(bufferInFillMode);
        }
    }

    static {
        ASSUMED_CONTENT_METHODS.put(HttpMethod.POST.asString(), Boolean.TRUE);
        ASSUMED_CONTENT_METHODS.put(HttpMethod.PUT.asString(), Boolean.TRUE);
        ZERO_CHUNK = new byte[]{48, 13, 10};
        LAST_CHUNK = new byte[]{48, 13, 10, 13, 10};
        CONTENT_LENGTH_0 = StringUtil.getBytes("Content-Length: 0\r\n");
        CONNECTION_CLOSE = StringUtil.getBytes("Connection: close\r\n");
        HTTP_1_1_SPACE = StringUtil.getBytes((Object)((Object)HttpVersion.HTTP_1_1) + " ");
        TRANSFER_ENCODING_CHUNKED = StringUtil.getBytes("Transfer-Encoding: chunked\r\n");
        SEND = new byte[][]{new byte[0], StringUtil.getBytes("Server: Jetty(9.x.x)\r\n"), StringUtil.getBytes("X-Powered-By: Jetty(9.x.x)\r\n"), StringUtil.getBytes("Server: Jetty(9.x.x)\r\nX-Powered-By: Jetty(9.x.x)\r\n")};
        __preprepared = new PreparedResponse[512];
        int versionLength = HttpVersion.HTTP_1_1.toString().length();
        for (int i2 = 0; i2 < __preprepared.length; ++i2) {
            HttpStatus.Code code = HttpStatus.getCode(i2);
            if (code == null) continue;
            String reason = code.getMessage();
            byte[] line = new byte[versionLength + 5 + reason.length() + 2];
            HttpVersion.HTTP_1_1.toBuffer().get(line, 0, versionLength);
            line[versionLength + 0] = 32;
            line[versionLength + 1] = (byte)(48 + i2 / 100);
            line[versionLength + 2] = (byte)(48 + i2 % 100 / 10);
            line[versionLength + 3] = (byte)(48 + i2 % 10);
            line[versionLength + 4] = 32;
            for (int j2 = 0; j2 < reason.length(); ++j2) {
                line[versionLength + 5 + j2] = (byte)reason.charAt(j2);
            }
            line[versionLength + 5 + reason.length()] = 13;
            line[versionLength + 6 + reason.length()] = 10;
            HttpGenerator.__preprepared[i2] = new PreparedResponse();
            HttpGenerator.__preprepared[i2]._schemeCode = Arrays.copyOfRange(line, 0, versionLength + 5);
            HttpGenerator.__preprepared[i2]._reason = Arrays.copyOfRange(line, versionLength + 5, line.length - 2);
            HttpGenerator.__preprepared[i2]._responseLine = line;
        }
    }

    private static class PreparedResponse {
        byte[] _reason;
        byte[] _schemeCode;
        byte[] _responseLine;

        private PreparedResponse() {
        }
    }

    public static enum Result {
        NEED_CHUNK,
        NEED_INFO,
        NEED_HEADER,
        HEADER_OVERFLOW,
        NEED_CHUNK_TRAILER,
        FLUSH,
        CONTINUE,
        SHUTDOWN_OUT,
        DONE;

    }

    public static enum State {
        START,
        COMMITTED,
        COMPLETING,
        COMPLETING_1XX,
        END;

    }
}

