/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.HttpHeaderValue;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.QuotedCSV;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.StringUtil;
import java.util.Objects;

public class HttpField {
    private final HttpHeader _header;
    private final String _name;
    private final String _value;
    private int hash = 0;

    public HttpField(HttpHeader header, String name, String value) {
        this._header = header;
        this._name = this._header != null && name == null ? this._header.asString() : Objects.requireNonNull(name, "name");
        this._value = value;
    }

    public HttpField(HttpHeader header, String value) {
        this(header, header.asString(), value);
    }

    public HttpField(HttpHeader header, HttpHeaderValue value) {
        this(header, header.asString(), value.asString());
    }

    public HttpField(String name, String value) {
        this(HttpHeader.CACHE.get(name), name, value);
    }

    public HttpHeader getHeader() {
        return this._header;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public long getLongValue() {
        return Long.parseLong(this._value);
    }

    public String[] getValues() {
        if (this._value == null) {
            return null;
        }
        QuotedCSV list = new QuotedCSV(false, this._value);
        return list.getValues().toArray(new String[list.size()]);
    }

    public boolean contains(String search) {
        if (search == null) {
            return this._value == null;
        }
        if (search.isEmpty()) {
            return false;
        }
        if (this._value == null) {
            return false;
        }
        if (search.equals(this._value)) {
            return true;
        }
        search = StringUtil.asciiToLowerCase(search);
        int state = 0;
        int match = 0;
        int param = 0;
        block31: for (int i2 = 0; i2 < this._value.length(); ++i2) {
            char c2 = this._value.charAt(i2);
            switch (state) {
                case 0: {
                    switch (c2) {
                        case '\"': {
                            match = 0;
                            state = 2;
                            continue block31;
                        }
                        case ',': {
                            continue block31;
                        }
                        case ';': {
                            param = -1;
                            match = -1;
                            state = 5;
                            continue block31;
                        }
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                    }
                    match = Character.toLowerCase(c2) == search.charAt(0) ? 1 : -1;
                    state = 1;
                    continue block31;
                }
                case 1: {
                    switch (c2) {
                        case ',': {
                            if (match == search.length()) {
                                return true;
                            }
                            state = 0;
                            continue block31;
                        }
                        case ';': {
                            param = match >= 0 ? 0 : -1;
                            state = 5;
                            continue block31;
                        }
                    }
                    if (match <= 0) continue block31;
                    if (match < search.length()) {
                        match = Character.toLowerCase(c2) == search.charAt(match) ? match + 1 : -1;
                        continue block31;
                    }
                    if (c2 == ' ' || c2 == '\t') continue block31;
                    match = -1;
                    continue block31;
                }
                case 2: {
                    switch (c2) {
                        case '\\': {
                            state = 3;
                            continue block31;
                        }
                        case '\"': {
                            state = 4;
                            continue block31;
                        }
                    }
                    if (match < 0) continue block31;
                    if (match < search.length()) {
                        match = Character.toLowerCase(c2) == search.charAt(match) ? match + 1 : -1;
                        continue block31;
                    }
                    match = -1;
                    continue block31;
                }
                case 3: {
                    if (match >= 0) {
                        match = match < search.length() ? (Character.toLowerCase(c2) == search.charAt(match) ? match + 1 : -1) : -1;
                    }
                    state = 2;
                    continue block31;
                }
                case 4: {
                    switch (c2) {
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                        case ';': {
                            state = 5;
                            continue block31;
                        }
                        case ',': {
                            if (match == search.length()) {
                                return true;
                            }
                            state = 0;
                            continue block31;
                        }
                    }
                    match = -1;
                    continue block31;
                }
                case 5: {
                    switch (c2) {
                        case ',': {
                            if (param != "q=0".length() && match == search.length()) {
                                return true;
                            }
                            param = 0;
                            state = 0;
                            continue block31;
                        }
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                    }
                    if (param < 0) continue block31;
                    if (param < "q=0".length()) {
                        param = Character.toLowerCase(c2) == "q=0".charAt(param) ? param + 1 : -1;
                        continue block31;
                    }
                    if (c2 == '0' || c2 == '.') continue block31;
                    param = -1;
                    continue block31;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return param != "q=0".length() && match == search.length();
    }

    public String toString() {
        String v2 = this.getValue();
        return this.getName() + ": " + (v2 == null ? "" : v2);
    }

    public boolean isSameName(HttpField field) {
        if (field == null) {
            return false;
        }
        if (field == this) {
            return true;
        }
        if (this._header != null && this._header == field.getHeader()) {
            return true;
        }
        return this._name.equalsIgnoreCase(field.getName());
    }

    public boolean is(String name) {
        return this._name.equalsIgnoreCase(name);
    }

    private int nameHashCode() {
        int h2 = this.hash;
        int len = this._name.length();
        if (h2 == 0 && len > 0) {
            for (int i2 = 0; i2 < len; ++i2) {
                char c2 = this._name.charAt(i2);
                if (c2 >= 'a' && c2 <= 'z') {
                    c2 = (char)(c2 - 32);
                }
                h2 = 31 * h2 + c2;
            }
            this.hash = h2;
        }
        return h2;
    }

    public int hashCode() {
        int vhc = Objects.hashCode(this._value);
        if (this._header == null) {
            return vhc ^ this.nameHashCode();
        }
        return vhc ^ this._header.hashCode();
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof HttpField)) {
            return false;
        }
        HttpField field = (HttpField)o2;
        if (this._header != field.getHeader()) {
            return false;
        }
        if (!this._name.equalsIgnoreCase(field.getName())) {
            return false;
        }
        return Objects.equals(this._value, field.getValue());
    }
}

