/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.client;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.client.ContentDecoder;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import java.nio.ByteBuffer;

public class GZIPContentDecoder
extends com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.http.GZIPContentDecoder
implements ContentDecoder {
    public GZIPContentDecoder() {
        this(8192);
    }

    public GZIPContentDecoder(int bufferSize) {
        this(null, bufferSize);
    }

    public GZIPContentDecoder(ByteBufferPool byteBufferPool, int bufferSize) {
        super(byteBufferPool, bufferSize);
    }

    @Override
    protected boolean decodedChunk(ByteBuffer chunk) {
        super.decodedChunk(chunk);
        return true;
    }

    public static class Factory
    extends ContentDecoder.Factory {
        private final int bufferSize;
        private final ByteBufferPool byteBufferPool;

        public Factory() {
            this(8192);
        }

        public Factory(int bufferSize) {
            this(null, bufferSize);
        }

        public Factory(ByteBufferPool byteBufferPool) {
            this(byteBufferPool, 8192);
        }

        public Factory(ByteBufferPool byteBufferPool, int bufferSize) {
            super("gzip");
            this.byteBufferPool = byteBufferPool;
            this.bufferSize = bufferSize;
        }

        @Override
        public ContentDecoder newContentDecoder() {
            return new GZIPContentDecoder(this.byteBufferPool, this.bufferSize);
        }
    }
}

