/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.client;

import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.client.AbstractHttpClientTransport;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.client.HttpDestination;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.Connection;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.ManagedSelector;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.SelectorManager;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.io.SocketChannelEndPoint;
import com.gradle.enterprise.testdistribution.internal.dep.org.eclipse.jetty.util.Promise;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;

public abstract class AbstractConnectorHttpClientTransport
extends AbstractHttpClientTransport {
    private final int selectors;
    private SelectorManager selectorManager;

    protected AbstractConnectorHttpClientTransport(int selectors) {
        this.selectors = selectors;
    }

    public int getSelectors() {
        return this.selectors;
    }

    @Override
    protected void doStart() throws Exception {
        HttpClient httpClient = this.getHttpClient();
        this.selectorManager = this.newSelectorManager(httpClient);
        this.selectorManager.setConnectTimeout(httpClient.getConnectTimeout());
        this.addBean(this.selectorManager);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.selectorManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(InetSocketAddress address, Map<String, Object> context) {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            HttpDestination destination = (HttpDestination)context.get("http.destination");
            HttpClient client = destination.getHttpClient();
            SocketAddress bindAddress = client.getBindAddress();
            if (bindAddress != null) {
                channel.bind(bindAddress);
            }
            this.configure(client, channel);
            context.put("ssl.peer.host", address.getHostString());
            context.put("ssl.peer.port", address.getPort());
            boolean connected = true;
            if (client.isConnectBlocking()) {
                channel.socket().connect(address, (int)client.getConnectTimeout());
                channel.configureBlocking(false);
            } else {
                channel.configureBlocking(false);
                connected = channel.connect(address);
            }
            if (connected) {
                this.selectorManager.accept(channel, context);
            } else {
                this.selectorManager.connect(channel, context);
            }
        }
        catch (Throwable x2) {
            if (x2.getClass() == SocketException.class) {
                x2 = new SocketException("Could not connect to " + address).initCause(x2);
            }
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException ignored) {
                LOG.ignore(ignored);
            }
            finally {
                this.connectFailed(context, x2);
            }
        }
    }

    protected void connectFailed(Map<String, Object> context, Throwable x2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not connect to {}", context.get("http.destination"));
        }
        Promise promise = (Promise)context.get("http.connection.promise");
        promise.failed(x2);
    }

    protected void configure(HttpClient client, SocketChannel channel) throws IOException {
        channel.socket().setTcpNoDelay(client.isTCPNoDelay());
    }

    protected SelectorManager newSelectorManager(HttpClient client) {
        return new ClientSelectorManager(client, this.getSelectors());
    }

    protected class ClientSelectorManager
    extends SelectorManager {
        private final HttpClient client;

        protected ClientSelectorManager(HttpClient client, int selectors) {
            super(client.getExecutor(), client.getScheduler(), selectors);
            this.client = client;
        }

        @Override
        protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey key) {
            SocketChannelEndPoint endp = new SocketChannelEndPoint(channel, selector, key, this.getScheduler());
            endp.setIdleTimeout(this.client.getIdleTimeout());
            return endp;
        }

        @Override
        public Connection newConnection(SelectableChannel channel, EndPoint endPoint, Object attachment) throws IOException {
            Map context = (Map)attachment;
            HttpDestination destination = (HttpDestination)context.get("http.destination");
            return destination.getClientConnectionFactory().newConnection(endPoint, context);
        }

        @Override
        protected void connectionFailed(SelectableChannel channel, Throwable x2, Object attachment) {
            Map context = (Map)attachment;
            AbstractConnectorHttpClientTransport.this.connectFailed(context, x2);
        }
    }
}

