/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.org.apache.commons.compress.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.LinkOption;

public final class IOUtils {
    public static final LinkOption[] EMPTY_LINK_OPTIONS = new LinkOption[0];
    private static final byte[] SKIP_BUF = new byte[4096];

    public static long skip(InputStream input, long numToSkip) throws IOException {
        int read;
        long skipped;
        long available = numToSkip;
        while (numToSkip > 0L && (skipped = input.skip(numToSkip)) != 0L) {
            numToSkip -= skipped;
        }
        while (numToSkip > 0L && (read = IOUtils.readFully(input, SKIP_BUF, 0, (int)Math.min(numToSkip, 4096L))) >= 1) {
            numToSkip -= (long)read;
        }
        return available - numToSkip;
    }

    public static int readFully(InputStream input, byte[] array) throws IOException {
        return IOUtils.readFully(input, array, 0, array.length);
    }

    public static int readFully(InputStream input, byte[] array, int offset, int len) throws IOException {
        int count;
        if (len < 0 || offset < 0 || len + offset > array.length || len + offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        int x2 = 0;
        for (count = 0; count != len && (x2 = input.read(array, offset + count, len - count)) != -1; count += x2) {
        }
        return count;
    }

    public static long copyRange(InputStream input, long len, OutputStream output) throws IOException {
        return IOUtils.copyRange(input, len, output, 8024);
    }

    public static long copyRange(InputStream input, long len, OutputStream output, int buffersize) throws IOException {
        long count;
        if (buffersize < 1) {
            throw new IllegalArgumentException("buffersize must be bigger than 0");
        }
        byte[] buffer = new byte[(int)Math.min((long)buffersize, len)];
        int n2 = 0;
        for (count = 0L; count < len && -1 != (n2 = input.read(buffer, 0, (int)Math.min(len - count, (long)buffer.length))); count += (long)n2) {
            output.write(buffer, 0, n2);
        }
        return count;
    }

    public static byte[] readRange(InputStream input, int len) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copyRange(input, len, output);
        return output.toByteArray();
    }
}

