/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.util;

import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.Serializer;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.SerializerFactory;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.util.Generics;
import java.util.HashMap;
import java.util.Map;

public class Util {
    public static final boolean isAndroid;
    public static final boolean unsafe;
    private static final Map<Class<?>, Class<?>> primitiveWrappers;

    public static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception ex) {
            Log.debug("kryo", "Class not available: " + className);
            return false;
        }
    }

    public static Class getWrapperClass(Class type) {
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        return type;
    }

    public static boolean isWrapperClass(Class type) {
        return type == Integer.class || type == Float.class || type == Boolean.class || type == Byte.class || type == Long.class || type == Character.class || type == Double.class || type == Short.class;
    }

    public static boolean isEnum(Class type) {
        return Enum.class.isAssignableFrom(type) && type != Enum.class;
    }

    public static void log(String message, Object object, int position) {
        if (object == null) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": null" + Util.pos(position));
            }
            return;
        }
        Class<?> type = object.getClass();
        if (type.isPrimitive() || Util.isWrapperClass(type) || type == String.class) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": " + Util.string(object) + Util.pos(position));
            }
        } else {
            Log.debug("kryo", message + ": " + Util.string(object) + Util.pos(position));
        }
    }

    public static String pos(int position) {
        return position == -1 ? "" : " [" + position + "]";
    }

    public static String string(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> type = object.getClass();
        if (type.isArray()) {
            return Util.className(type);
        }
        String className = Log.TRACE ? Util.className(type) : type.getSimpleName();
        try {
            if (type.getMethod("toString", new Class[0]).getDeclaringClass() == Object.class) {
                return className;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String value = String.valueOf(object) + " (" + className + ")";
            return value.length() > 97 ? value.substring(0, 97) + "..." : value;
        }
        catch (Throwable ex) {
            return className + " (toString exception: " + ex + ")";
        }
    }

    public static String className(Class type) {
        if (type == null) {
            return "null";
        }
        if (type.isArray()) {
            Class elementClass = Util.getElementClass(type);
            StringBuilder buffer = new StringBuilder(16);
            int n2 = Util.getDimensionCount(type);
            for (int i2 = 0; i2 < n2; ++i2) {
                buffer.append("[]");
            }
            return Util.className(elementClass) + buffer;
        }
        if (type.isPrimitive() || type == Object.class || type == Boolean.class || type == Byte.class || type == Character.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == String.class) {
            return type.getSimpleName();
        }
        return type.getName();
    }

    public static String canonicalName(Class type) {
        if (type == null) {
            return "null";
        }
        String canonicalName = type.getCanonicalName();
        return canonicalName != null ? canonicalName : Util.className(type);
    }

    public static String simpleName(Class type, Generics.GenericType genericType) {
        int i2;
        int n2;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append((type.isArray() ? Util.getElementClass(type) : type).getSimpleName());
        if (genericType.arguments != null) {
            buffer.append('<');
            n2 = genericType.arguments.length;
            for (i2 = 0; i2 < n2; ++i2) {
                if (i2 > 0) {
                    buffer.append(", ");
                }
                buffer.append(genericType.arguments[i2].toString());
            }
            buffer.append('>');
        }
        if (type.isArray()) {
            n2 = Util.getDimensionCount(type);
            for (i2 = 0; i2 < n2; ++i2) {
                buffer.append("[]");
            }
        }
        return buffer.toString();
    }

    public static int getDimensionCount(Class arrayClass) {
        int depth = 0;
        for (Class<?> nextClass = arrayClass.getComponentType(); nextClass != null; nextClass = nextClass.getComponentType()) {
            ++depth;
        }
        return depth;
    }

    public static Class getElementClass(Class arrayClass) {
        Class<?> elementClass = arrayClass;
        while (elementClass.getComponentType() != null) {
            elementClass = elementClass.getComponentType();
        }
        return elementClass;
    }

    public static boolean isAscii(String value) {
        int n2 = value.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (value.charAt(i2) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static <T extends SerializerFactory> T newFactory(Class<T> factoryClass, Class<? extends Serializer> serializerClass) {
        try {
            if (serializerClass != null) {
                try {
                    return (T)((SerializerFactory)factoryClass.getConstructor(Class.class).newInstance(serializerClass));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return (T)((SerializerFactory)factoryClass.newInstance());
        }
        catch (Exception ex) {
            if (serializerClass == null) {
                throw new IllegalArgumentException("Unable to create serializer factory: " + factoryClass.getName(), ex);
            }
            throw new IllegalArgumentException("Unable to create serializer factory \"" + factoryClass.getName() + "\" for serializer class: " + Util.className(serializerClass), ex);
        }
    }

    static {
        boolean found;
        block5: {
            isAndroid = "Dalvik".equals(System.getProperty("java.vm.name"));
            found = false;
            if ("false".equals(System.getProperty("kryo.unsafe"))) {
                if (Log.TRACE) {
                    Log.trace("kryo", "Unsafe is disabled.");
                }
            } else {
                try {
                    found = Class.forName("com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.unsafe.UnsafeUtil", true, FieldSerializer.class.getClassLoader()).getField("unsafe").get(null) != null;
                }
                catch (Throwable ex) {
                    if (!Log.TRACE) break block5;
                    Log.trace("kryo", "Unsafe is unavailable.", ex);
                }
            }
        }
        unsafe = found;
        primitiveWrappers = new HashMap();
        primitiveWrappers.put(Boolean.TYPE, Boolean.class);
        primitiveWrappers.put(Byte.TYPE, Byte.class);
        primitiveWrappers.put(Character.TYPE, Character.class);
        primitiveWrappers.put(Double.TYPE, Double.class);
        primitiveWrappers.put(Float.TYPE, Float.class);
        primitiveWrappers.put(Integer.TYPE, Integer.class);
        primitiveWrappers.put(Long.TYPE, Long.class);
        primitiveWrappers.put(Short.TYPE, Short.class);
    }
}

