/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.util;

import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class Pool<T> {
    private final Queue<T> freeObjects;
    private int peak;

    public Pool(boolean threadSafe, boolean softReferences) {
        this(threadSafe, softReferences, Integer.MAX_VALUE);
    }

    public Pool(boolean threadSafe, boolean softReferences, final int maximumCapacity) {
        AbstractCollection queue = threadSafe ? new LinkedBlockingQueue<T>(maximumCapacity){

            @Override
            public boolean add(T o2) {
                return super.offer(o2);
            }
        } : (softReferences ? new LinkedList<T>(){

            @Override
            public boolean add(T object) {
                if (this.size() >= maximumCapacity) {
                    return false;
                }
                super.add(object);
                return true;
            }
        } : new ArrayDeque<T>(){

            @Override
            public boolean offer(T object) {
                if (this.size() >= maximumCapacity) {
                    return false;
                }
                super.offer(object);
                return true;
            }
        });
        this.freeObjects = softReferences ? new SoftReferenceQueue(queue) : queue;
    }

    protected abstract T create();

    public T obtain() {
        T object = this.freeObjects.poll();
        return object != null ? object : this.create();
    }

    public void free(T object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        this.reset(object);
        if (!this.freeObjects.offer(object) && this.freeObjects instanceof SoftReferenceQueue) {
            ((SoftReferenceQueue)this.freeObjects).cleanOne();
            this.freeObjects.offer(object);
        }
        this.peak = Math.max(this.peak, this.freeObjects.size());
    }

    protected void reset(T object) {
        if (object instanceof Poolable) {
            ((Poolable)object).reset();
        }
    }

    static class SoftReferenceQueue<T>
    implements Queue<T> {
        private final Queue<SoftReference<T>> delegate;

        public SoftReferenceQueue(Queue<SoftReference<T>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T poll() {
            SoftReference<T> reference;
            T object;
            do {
                if ((reference = this.delegate.poll()) != null) continue;
                return null;
            } while ((object = reference.get()) == null);
            return object;
        }

        @Override
        public boolean offer(T e2) {
            return this.delegate.add(new SoftReference<T>(e2));
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        void cleanOne() {
            Iterator iter = this.delegate.iterator();
            while (iter.hasNext()) {
                if (((SoftReference)iter.next()).get() != null) continue;
                iter.remove();
                break;
            }
        }

        @Override
        public boolean add(T e2) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o2) {
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            return null;
        }

        @Override
        public T remove() {
            return null;
        }

        @Override
        public Object[] toArray() {
            return null;
        }

        @Override
        public T element() {
            return null;
        }

        @Override
        public T peek() {
            return null;
        }

        @Override
        public <E> E[] toArray(E[] a2) {
            return null;
        }

        @Override
        public boolean remove(Object o2) {
            return false;
        }

        @Override
        public boolean containsAll(Collection c2) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends T> c2) {
            return false;
        }

        @Override
        public boolean removeAll(Collection c2) {
            return false;
        }

        @Override
        public boolean retainAll(Collection c2) {
            return false;
        }
    }

    public static interface Poolable {
        public void reset();
    }
}

