/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectMap<K, V>
implements Iterable<Entry<K, V>> {
    static final Object dummy = new Object();
    public int size;
    K[] keyTable;
    V[] valueTable;
    float loadFactor;
    int threshold;
    protected int shift;
    protected int mask;

    public ObjectMap() {
        this(51, 0.8f);
    }

    public ObjectMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = ObjectMap.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[tableSize];
        this.valueTable = new Object[tableSize];
    }

    protected int place(K item) {
        return (int)((long)item.hashCode() * -7046029254386353131L >>> this.shift);
    }

    int locateKey(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        K[] keyTable = this.keyTable;
        int i2 = this.place(key);
        K other;
        while ((other = keyTable[i2]) != null) {
            if (other.equals(key)) {
                return i2;
            }
            i2 = i2 + 1 & this.mask;
        }
        return -(i2 + 1);
    }

    public V put(K key, V value) {
        int i2 = this.locateKey(key);
        if (i2 >= 0) {
            V oldValue = this.valueTable[i2];
            this.valueTable[i2] = value;
            return oldValue;
        }
        i2 = -(i2 + 1);
        this.keyTable[i2] = key;
        this.valueTable[i2] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    private void putResize(K key, V value) {
        K[] keyTable = this.keyTable;
        int i2 = this.place(key);
        while (true) {
            if (keyTable[i2] == null) {
                keyTable[i2] = key;
                this.valueTable[i2] = value;
                return;
            }
            i2 = i2 + 1 & this.mask;
        }
    }

    public <T extends K> V get(T key) {
        int i2 = this.place(key);
        K other;
        while ((other = this.keyTable[i2]) != null) {
            if (other.equals(key)) {
                return this.valueTable[i2];
            }
            i2 = i2 + 1 & this.mask;
        }
        return null;
    }

    public V get(K key, V defaultValue) {
        int i2 = this.place(key);
        K other;
        while ((other = this.keyTable[i2]) != null) {
            if (other.equals(key)) {
                return this.valueTable[i2];
            }
            i2 = i2 + 1 & this.mask;
        }
        return defaultValue;
    }

    public V remove(K key) {
        int i2 = this.locateKey(key);
        if (i2 < 0) {
            return null;
        }
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        V oldValue = valueTable[i2];
        int mask = this.mask;
        int next = i2 + 1 & mask;
        while ((key = keyTable[next]) != null) {
            int placement = this.place(key);
            if ((next - placement & mask) > (i2 - placement & mask)) {
                keyTable[i2] = key;
                valueTable[i2] = valueTable[next];
                i2 = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i2] = null;
        valueTable[i2] = null;
        --this.size;
        return oldValue;
    }

    public void clear(int maximumCapacity) {
        int tableSize = ObjectMap.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(tableSize);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, null);
        Arrays.fill(this.valueTable, null);
    }

    public boolean containsKey(K key) {
        return this.locateKey(key) >= 0;
    }

    final void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        K[] oldKeyTable = this.keyTable;
        V[] oldValueTable = this.valueTable;
        this.keyTable = new Object[newSize];
        this.valueTable = new Object[newSize];
        if (this.size > 0) {
            for (int i2 = 0; i2 < oldCapacity; ++i2) {
                K key = oldKeyTable[i2];
                if (key == null) continue;
                this.putResize(key, oldValueTable[i2]);
            }
        }
    }

    public int hashCode() {
        int h2 = this.size;
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n2 = keyTable.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            K key = keyTable[i2];
            if (key == null) continue;
            h2 += key.hashCode();
            V value = valueTable[i2];
            if (value == null) continue;
            h2 += value.hashCode();
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectMap)) {
            return false;
        }
        ObjectMap other = (ObjectMap)obj;
        if (other.size != this.size) {
            return false;
        }
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n2 = keyTable.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            V value;
            K key = keyTable[i2];
            if (key == null || !((value = valueTable[i2]) == null ? other.get(key, dummy) != null : !value.equals(other.get(key)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(", ", true);
    }

    private String toString(String separator, boolean braces) {
        V value;
        K key;
        if (this.size == 0) {
            return braces ? "{}" : "";
        }
        StringBuilder buffer = new StringBuilder(32);
        if (braces) {
            buffer.append('{');
        }
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i2 = keyTable.length;
        while (i2-- > 0) {
            key = keyTable[i2];
            if (key == null) continue;
            buffer.append((Object)(key == this ? "(this)" : key));
            buffer.append('=');
            value = valueTable[i2];
            buffer.append((Object)(value == this ? "(this)" : value));
            break;
        }
        while (i2-- > 0) {
            key = keyTable[i2];
            if (key == null) continue;
            buffer.append(separator);
            buffer.append((Object)(key == this ? "(this)" : key));
            buffer.append('=');
            value = valueTable[i2];
            buffer.append((Object)(value == this ? "(this)" : value));
        }
        if (braces) {
            buffer.append('}');
        }
        return buffer.toString();
    }

    public Entries<K, V> iterator() {
        return this.entries();
    }

    public Entries<K, V> entries() {
        return new Entries(this);
    }

    public static int tableSize(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity must be >= 0: " + capacity);
        }
        int tableSize = ObjectMap.nextPowerOfTwo(Math.max(2, (int)Math.ceil((float)capacity / loadFactor)));
        if (tableSize > 0x40000000) {
            throw new IllegalArgumentException("The required capacity is too large: " + capacity);
        }
        return tableSize;
    }

    public static int nextPowerOfTwo(int value) {
        if (value == 0) {
            return 1;
        }
        --value;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        return value + 1;
    }

    public static class Entries<K, V>
    extends MapIterator<K, V, Entry<K, V>> {
        Entry<K, V> entry = new Entry();

        public Entries(ObjectMap<K, V> map) {
            super(map);
        }

        @Override
        public Entry<K, V> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            K[] keyTable = this.map.keyTable;
            this.entry.key = keyTable[this.nextIndex];
            this.entry.value = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        public Entries<K, V> iterator() {
            return this;
        }
    }

    private static abstract class MapIterator<K, V, I>
    implements Iterable<I>,
    Iterator<I> {
        public boolean hasNext;
        final ObjectMap<K, V> map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(ObjectMap<K, V> map) {
            this.map = map;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        void findNextIndex() {
            K[] keyTable = this.map.keyTable;
            int n2 = keyTable.length;
            while (++this.nextIndex < n2) {
                if (keyTable[this.nextIndex] == null) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            Object key;
            int i2 = this.currentIndex;
            if (i2 < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            K[] keyTable = this.map.keyTable;
            V[] valueTable = this.map.valueTable;
            int mask = this.map.mask;
            int next = i2 + 1 & mask;
            while ((key = keyTable[next]) != null) {
                int placement = this.map.place(key);
                if ((next - placement & mask) > (i2 - placement & mask)) {
                    keyTable[i2] = key;
                    valueTable[i2] = valueTable[next];
                    i2 = next;
                }
                next = next + 1 & mask;
            }
            keyTable[i2] = null;
            valueTable[i2] = null;
            --this.map.size;
            if (i2 != this.currentIndex) {
                --this.nextIndex;
            }
            this.currentIndex = -1;
        }
    }

    public static class Entry<K, V> {
        public K key;
        public V value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

