/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.util;

import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.KryoException;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.objenesis.instantiator.ObjectInstantiator;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.objenesis.strategy.InstantiatorStrategy;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.reflectasm.ConstructorAccess;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.util.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class DefaultInstantiatorStrategy
implements InstantiatorStrategy {
    private InstantiatorStrategy fallbackStrategy;

    public ObjectInstantiator newInstantiatorOf(final Class type) {
        if (!Util.isAndroid) {
            boolean isNonStaticMemberClass;
            Class<?> enclosingType = type.getEnclosingClass();
            boolean bl = isNonStaticMemberClass = enclosingType != null && type.isMemberClass() && !Modifier.isStatic(type.getModifiers());
            if (!isNonStaticMemberClass) {
                try {
                    final ConstructorAccess access = ConstructorAccess.get(type);
                    return new ObjectInstantiator(){

                        public Object newInstance() {
                            try {
                                return access.newInstance();
                            }
                            catch (Exception ex) {
                                throw new KryoException("Error constructing instance of class: " + Util.className(type), ex);
                            }
                        }
                    };
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            Constructor ctor;
            try {
                ctor = type.getConstructor(null);
            }
            catch (Exception ex) {
                ctor = type.getDeclaredConstructor(null);
                ctor.setAccessible(true);
            }
            final Constructor constructor = ctor;
            return new ObjectInstantiator(){

                public Object newInstance() {
                    try {
                        return constructor.newInstance(new Object[0]);
                    }
                    catch (Exception ex) {
                        throw new KryoException("Error constructing instance of class: " + Util.className(type), ex);
                    }
                }
            };
        }
        catch (Exception ctor) {
            if (this.fallbackStrategy == null) {
                if (type.isMemberClass() && !Modifier.isStatic(type.getModifiers())) {
                    throw new KryoException("Class cannot be created (non-static member class): " + Util.className(type));
                }
                StringBuilder message = new StringBuilder("Class cannot be created (missing no-arg constructor): " + Util.className(type));
                if (type.getSimpleName().equals("")) {
                    message.append("\nNote: This is an anonymous class, which is not serializable by default in Kryo. Possible solutions:\n").append("1. Remove uses of anonymous classes, including double brace initialization, from the containing\n").append("class. This is the safest solution, as anonymous classes don't have predictable names for serialization.\n").append("2. Register a FieldSerializer for the containing class and call FieldSerializer\n").append("setIgnoreSyntheticFields(false) on it. This is not safe but may be sufficient temporarily.");
                }
                throw new KryoException(message.toString());
            }
            return this.fallbackStrategy.newInstantiatorOf(type);
        }
    }
}

