/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.serializers;

import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.Kryo;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.KryoException;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.Serializer;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.SerializerFactory;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.io.Input;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.io.Output;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.reflectasm.FieldAccess;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.serializers.CachedFields;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.serializers.ReflectField;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.util.Generics;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.util.Util;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;

public class FieldSerializer<T>
extends Serializer<T> {
    final Kryo kryo;
    final Class type;
    final FieldSerializerConfig config;
    final CachedFields cachedFields;
    private final Generics.GenericsHierarchy genericsHierarchy;

    public FieldSerializer(Kryo kryo, Class type) {
        this(kryo, type, new FieldSerializerConfig());
    }

    public FieldSerializer(Kryo kryo, Class type, FieldSerializerConfig config) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("type cannot be a primitive class: " + type);
        }
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null.");
        }
        this.kryo = kryo;
        this.type = type;
        this.config = config;
        this.genericsHierarchy = new Generics.GenericsHierarchy(type);
        this.cachedFields = new CachedFields(this);
        this.cachedFields.rebuild();
    }

    protected void initializeCachedFields() {
    }

    public FieldSerializerConfig getFieldSerializerConfig() {
        return this.config;
    }

    public void updateFields() {
        if (Log.TRACE) {
            Log.trace("kryo", "Update fields: " + Util.className(this.type));
        }
        this.cachedFields.rebuild();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        int pop = this.pushTypeVariables();
        CachedField[] fields = this.cachedFields.fields;
        int n2 = fields.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Log.TRACE) {
                this.log("Write", fields[i2], output.position());
            }
            try {
                fields[i2].write(output, object);
                continue;
            }
            catch (KryoException e2) {
                throw e2;
            }
            catch (Exception | OutOfMemoryError e3) {
                throw new KryoException("Error writing " + fields[i2] + " at position " + output.position(), e3);
            }
        }
        this.popTypeVariables(pop);
    }

    @Override
    public T read(Kryo kryo, Input input, Class<? extends T> type) {
        int pop = this.pushTypeVariables();
        T object = this.create(kryo, input, type);
        kryo.reference(object);
        CachedField[] fields = this.cachedFields.fields;
        int n2 = fields.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Log.TRACE) {
                this.log("Read", fields[i2], input.position());
            }
            try {
                fields[i2].read(input, object);
                continue;
            }
            catch (KryoException e2) {
                throw e2;
            }
            catch (Exception | OutOfMemoryError e3) {
                throw new KryoException("Error reading " + fields[i2] + " at position " + input.position(), e3);
            }
        }
        this.popTypeVariables(pop);
        return object;
    }

    protected int pushTypeVariables() {
        Generics.GenericType[] genericTypes = this.kryo.getGenerics().nextGenericTypes();
        if (genericTypes == null) {
            return 0;
        }
        int pop = this.kryo.getGenerics().pushTypeVariables(this.genericsHierarchy, genericTypes);
        if (Log.TRACE && pop > 0) {
            Log.trace("kryo", "Generics: " + this.kryo.getGenerics());
        }
        return pop;
    }

    protected void popTypeVariables(int pop) {
        Generics generics = this.kryo.getGenerics();
        if (pop > 0) {
            generics.popTypeVariables(pop);
        }
        generics.popGenericType();
    }

    protected T create(Kryo kryo, Input input, Class<? extends T> type) {
        return kryo.newInstance(type);
    }

    protected void log(String prefix, CachedField cachedField, int position) {
        String fieldClassName;
        if (cachedField instanceof ReflectField) {
            ReflectField reflectField = (ReflectField)cachedField;
            Class<?> fieldClass = reflectField.resolveFieldClass();
            if (fieldClass == null) {
                fieldClass = cachedField.field.getType();
            }
            fieldClassName = Util.simpleName(fieldClass, reflectField.genericType);
        } else {
            fieldClassName = cachedField.valueClass != null ? cachedField.valueClass.getSimpleName() : cachedField.field.getType().getSimpleName();
        }
        Log.trace("kryo", prefix + " field " + fieldClassName + ": " + cachedField.name + " (" + Util.className(cachedField.field.getDeclaringClass()) + ')' + Util.pos(position));
    }

    public CachedField getField(String fieldName) {
        for (CachedField cachedField : this.cachedFields.fields) {
            if (!cachedField.name.equals(fieldName)) continue;
            return cachedField;
        }
        throw new IllegalArgumentException("Field \"" + fieldName + "\" not found on class: " + this.type.getName());
    }

    public void removeField(String fieldName) {
        this.cachedFields.removeField(fieldName);
    }

    public void removeField(CachedField field) {
        this.cachedFields.removeField(field);
    }

    public CachedField[] getFields() {
        return this.cachedFields.fields;
    }

    public CachedField[] getCopyFields() {
        return this.cachedFields.copyFields;
    }

    public Class getType() {
        return this.type;
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    protected T createCopy(Kryo kryo, T original) {
        return (T)kryo.newInstance(original.getClass());
    }

    @Override
    public T copy(Kryo kryo, T original) {
        T copy = this.createCopy(kryo, original);
        kryo.reference(copy);
        int n2 = this.cachedFields.copyFields.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.cachedFields.copyFields[i2].copy(original, copy);
        }
        return copy;
    }

    public static class FieldSerializerConfig
    implements Cloneable {
        boolean fieldsCanBeNull = true;
        boolean setFieldsAsAccessible = true;
        boolean ignoreSyntheticFields = true;
        boolean fixedFieldTypes;
        boolean copyTransient = true;
        boolean serializeTransient;
        boolean varEncoding = true;
        boolean extendedFieldNames;

        public FieldSerializerConfig clone() {
            try {
                return (FieldSerializerConfig)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new KryoException(ex);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NotNull {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Bind {
        public Class valueClass() default Object.class;

        public Class<? extends Serializer> serializer() default Serializer.class;

        public Class<? extends SerializerFactory> serializerFactory() default SerializerFactory.class;

        public boolean canBeNull() default true;

        public boolean variableLengthEncoding() default true;

        public boolean optimizePositive() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Optional {
        public String value();
    }

    public static abstract class CachedField {
        final Field field;
        String name;
        Class valueClass;
        Serializer serializer;
        boolean canBeNull;
        boolean varEncoding = true;
        boolean optimizePositive;
        boolean reuseSerializer = true;
        FieldAccess access;
        int accessIndex = -1;
        long offset;
        int tag;

        public CachedField(Field field) {
            this.field = field;
        }

        public void setValueClass(Class valueClass) {
            this.valueClass = valueClass;
        }

        public void setSerializer(Serializer serializer) {
            this.serializer = serializer;
        }

        public void setCanBeNull(boolean canBeNull) {
            this.canBeNull = canBeNull;
        }

        public void setVariableLengthEncoding(boolean varEncoding) {
            this.varEncoding = varEncoding;
        }

        public void setOptimizePositive(boolean optimizePositive) {
            this.optimizePositive = optimizePositive;
        }

        void setReuseSerializer(boolean reuseSerializer) {
            this.reuseSerializer = reuseSerializer;
        }

        public String toString() {
            return this.name;
        }

        public abstract void write(Output var1, Object var2);

        public abstract void read(Input var1, Object var2);

        public abstract void copy(Object var1, Object var2);
    }
}

