/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.serializers;

import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.Kryo;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.Serializer;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.io.Input;
import com.gradle.enterprise.testdistribution.internal.dep.com.esotericsoftware.kryo.kryo5.io.Output;
import java.lang.reflect.Array;

public class DefaultArraySerializers {

    public static class ObjectArraySerializer
    extends Serializer<Object[]> {
        private boolean elementsAreSameType;
        private boolean elementsCanBeNull;

        @Override
        public void write(Kryo kryo, Output output, Object[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            int n2 = object.length;
            output.writeVarInt(n2 + 1, true);
            Class<?> elementClass = object.getClass().getComponentType();
            if (this.elementsAreSameType || kryo.isFinal(elementClass)) {
                Serializer elementSerializer = kryo.getSerializer(elementClass);
                if (this.elementsCanBeNull) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        kryo.writeObjectOrNull(output, object[i2], elementSerializer);
                    }
                } else {
                    for (int i3 = 0; i3 < n2; ++i3) {
                        kryo.writeObject(output, object[i3], elementSerializer);
                    }
                }
            } else {
                for (int i4 = 0; i4 < n2; ++i4) {
                    kryo.writeClassAndObject(output, object[i4]);
                }
            }
        }

        @Override
        public Object[] read(Kryo kryo, Input input, Class type) {
            int n2 = input.readVarInt(true);
            if (n2 == 0) {
                return null;
            }
            Object[] object = (Object[])Array.newInstance(type.getComponentType(), --n2);
            kryo.reference(object);
            Class<?> elementClass = type.getComponentType();
            if (this.elementsAreSameType || kryo.isFinal(elementClass)) {
                Serializer elementSerializer = kryo.getSerializer(elementClass);
                if (this.elementsCanBeNull) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        object[i2] = kryo.readObjectOrNull(input, elementClass, elementSerializer);
                    }
                } else {
                    for (int i3 = 0; i3 < n2; ++i3) {
                        object[i3] = kryo.readObject(input, elementClass, elementSerializer);
                    }
                }
            } else {
                for (int i4 = 0; i4 < n2; ++i4) {
                    object[i4] = kryo.readClassAndObject(input);
                }
            }
            return object;
        }

        @Override
        public Object[] copy(Kryo kryo, Object[] original) {
            int n2 = original.length;
            Object[] copy = (Object[])Array.newInstance(original.getClass().getComponentType(), n2);
            kryo.reference(copy);
            for (int i2 = 0; i2 < n2; ++i2) {
                copy[i2] = kryo.copy(original[i2]);
            }
            return copy;
        }
    }

    public static class StringArraySerializer
    extends Serializer<String[]> {
        public StringArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, String[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            if (kryo.getReferences() && kryo.getReferenceResolver().useReferences(String.class)) {
                Serializer serializer = kryo.getSerializer(String.class);
                int n2 = object.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    kryo.writeObjectOrNull(output, (Object)object[i2], serializer);
                }
            } else {
                int n3 = object.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    output.writeString(object[i3]);
                }
            }
        }

        @Override
        public String[] read(Kryo kryo, Input input, Class type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            String[] array = new String[--length];
            if (kryo.getReferences() && kryo.getReferenceResolver().useReferences(String.class)) {
                Serializer serializer = kryo.getSerializer(String.class);
                for (int i2 = 0; i2 < length; ++i2) {
                    array[i2] = kryo.readObjectOrNull(input, String.class, serializer);
                }
            } else {
                for (int i3 = 0; i3 < length; ++i3) {
                    array[i3] = input.readString();
                }
            }
            return array;
        }

        @Override
        public String[] copy(Kryo kryo, String[] original) {
            String[] copy = new String[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    public static class BooleanArraySerializer
    extends Serializer<boolean[]> {
        public BooleanArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, boolean[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            int n2 = object.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                output.writeBoolean(object[i2]);
            }
        }

        @Override
        public boolean[] read(Kryo kryo, Input input, Class type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            boolean[] array = new boolean[--length];
            for (int i2 = 0; i2 < length; ++i2) {
                array[i2] = input.readBoolean();
            }
            return array;
        }

        @Override
        public boolean[] copy(Kryo kryo, boolean[] original) {
            boolean[] copy = new boolean[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    public static class DoubleArraySerializer
    extends Serializer<double[]> {
        public DoubleArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, double[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeDoubles(object, 0, object.length);
        }

        @Override
        public double[] read(Kryo kryo, Input input, Class type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readDoubles(length - 1);
        }

        @Override
        public double[] copy(Kryo kryo, double[] original) {
            double[] copy = new double[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    public static class CharArraySerializer
    extends Serializer<char[]> {
        public CharArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, char[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeChars(object, 0, object.length);
        }

        @Override
        public char[] read(Kryo kryo, Input input, Class type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readChars(length - 1);
        }

        @Override
        public char[] copy(Kryo kryo, char[] original) {
            char[] copy = new char[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    public static class ShortArraySerializer
    extends Serializer<short[]> {
        public ShortArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, short[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeShorts(object, 0, object.length);
        }

        @Override
        public short[] read(Kryo kryo, Input input, Class type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readShorts(length - 1);
        }

        @Override
        public short[] copy(Kryo kryo, short[] original) {
            short[] copy = new short[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    public static class LongArraySerializer
    extends Serializer<long[]> {
        public LongArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, long[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeLongs(object, 0, object.length, false);
        }

        @Override
        public long[] read(Kryo kryo, Input input, Class type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readLongs(length - 1, false);
        }

        @Override
        public long[] copy(Kryo kryo, long[] original) {
            long[] copy = new long[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    public static class FloatArraySerializer
    extends Serializer<float[]> {
        public FloatArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, float[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeFloats(object, 0, object.length);
        }

        @Override
        public float[] read(Kryo kryo, Input input, Class type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readFloats(length - 1);
        }

        @Override
        public float[] copy(Kryo kryo, float[] original) {
            float[] copy = new float[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    public static class IntArraySerializer
    extends Serializer<int[]> {
        public IntArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, int[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeInts(object, 0, object.length, false);
        }

        @Override
        public int[] read(Kryo kryo, Input input, Class type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readInts(length - 1, false);
        }

        @Override
        public int[] copy(Kryo kryo, int[] original) {
            int[] copy = new int[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    public static class ByteArraySerializer
    extends Serializer<byte[]> {
        public ByteArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, byte[] object) {
            if (object == null) {
                output.writeByte((byte)0);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeBytes(object);
        }

        @Override
        public byte[] read(Kryo kryo, Input input, Class type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readBytes(length - 1);
        }

        @Override
        public byte[] copy(Kryo kryo, byte[] original) {
            byte[] copy = new byte[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }
}

