/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.gradleplugin.testdistribution.internal;

import com.gradle.enterprise.testdistribution.obfuscated.aw.d;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.process.CommandLineArgumentProvider;

abstract class GradleDistribution
implements CommandLineArgumentProvider {
    private final Path gradleHome;

    private GradleDistribution(Path gradleHome) {
        this.gradleHome = gradleHome;
    }

    @Classpath
    public Set<File> getLibs() {
        Path libDir = this.gradleHome.resolve("lib");
        return GradleDistribution.asSortedSet(this.fileTree(libDir, (Action<? super ConfigurableFileTree>)((Action)tree -> tree.include(new String[]{"*.jar"}))));
    }

    @Classpath
    public Set<File> getPlugins() {
        Path pluginsDir = this.gradleHome.resolve("lib/plugins");
        return GradleDistribution.asSortedSet(this.fileTree(pluginsDir, (Action<? super ConfigurableFileTree>)((Action)tree -> tree.include(new String[]{"*.jar"}))));
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getStaticContent() {
        return this.fileTree(this.gradleHome, (Action<? super ConfigurableFileTree>)((Action)tree -> {
            tree.exclude(new String[]{"lib/**"});
            tree.exclude(new String[]{"samples/**"});
            tree.exclude(new String[]{"src/**"});
            tree.exclude(new String[]{"docs/**"});
            tree.exclude(new String[]{"getting-started.html"});
        }));
    }

    protected abstract ConfigurableFileTree fileTree(Path var1, Action<? super ConfigurableFileTree> var2);

    private static SortedSet<File> asSortedSet(ConfigurableFileTree fileTree) {
        return new TreeSet<File>(fileTree.getFiles());
    }

    public Iterable<String> asArguments() {
        return Collections.emptyList();
    }

    static GradleDistribution create(Path gradleHome, Project project) {
        return d.e() ? new b(gradleHome, project.getObjects()) : new a(gradleHome, project);
    }

    private static class b
    extends GradleDistribution {
        private final ObjectFactory a;

        b(Path gradleHome, ObjectFactory objects) {
            super(gradleHome);
            this.a = objects;
        }

        @Override
        protected ConfigurableFileTree fileTree(Path baseDir, Action<? super ConfigurableFileTree> action) {
            ConfigurableFileTree fileTree = this.a.fileTree().from((Object)baseDir);
            action.execute((Object)fileTree);
            return fileTree;
        }
    }

    private static class a
    extends GradleDistribution {
        private final Project a;

        a(Path gradleHome, Project project) {
            super(gradleHome);
            this.a = project;
        }

        @Override
        protected ConfigurableFileTree fileTree(Path baseDir, Action<? super ConfigurableFileTree> action) {
            return this.a.fileTree((Object)baseDir, action);
        }
    }
}

