/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.gradleplugin.testdistribution.internal;

import com.gradle.enterprise.testdistribution.client.selection.b;
import com.gradle.enterprise.testdistribution.client.selection.c;
import com.gradle.enterprise.testdistribution.obfuscated.k.n;
import com.gradle.obfuscation.Keep;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

@Keep
@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
public abstract class FingerprintMapperTask
extends DefaultTask {
    public static final String TASK_NAME = "remapPtsFingerprints";

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getToRemapFile();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getHashMapFile();

    @OutputFile
    public abstract Property<File> getOutputFile();

    public FingerprintMapperTask() {
        this.getOutputFile().set(this.getToRemapFile().map(f2 -> new File(f2.getAsFile().getParentFile(), f2.getAsFile().getName() + ".mapped.json")));
    }

    @TaskAction
    void remapFile() throws IOException {
        File outputFile = (File)this.getOutputFile().get();
        this.getLogger().lifecycle("Remapped file will be written to {}", new Object[]{outputFile});
        try (OutputStream outputStream = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);){
            FingerprintMapperTask.remapFileBasedInputs(((File)this.getToRemapFile().getAsFile().get()).toPath(), ((File)this.getHashMapFile().getAsFile().get()).toPath(), outputStream);
        }
    }

    private static void remapFileBasedInputs(Path inputFilePath, Path hashMapFilePath, OutputStream outputStream) throws IOException {
        c hashResolver = com.gradle.enterprise.testdistribution.obfuscated.bv.c.a().a(Files.readAllBytes(hashMapFilePath), c.class);
        try (InputStream fileToRemapStream = Files.newInputStream(inputFilePath, new OpenOption[0]);){
            n root = com.gradle.enterprise.testdistribution.obfuscated.bv.c.a().a(fileToRemapStream);
            b.a(root, hashResolver);
            com.gradle.enterprise.testdistribution.obfuscated.bv.c.a().h().a(outputStream, (Object)root);
        }
    }

    @Option(option="input-file", description="The JSON file containing input file and class name hash codes to remap.")
    public void setToRemapFileViaOption(String path) {
        this.getToRemapFile().set(new File(path));
    }

    @Option(option="hash-file", description="File containing a map of hash codes to input file paths and class names.")
    public void setHashMapFileViaOption(String path) {
        this.getHashMapFile().set(new File(path));
    }
}

