/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.gradleplugin.testdistribution.internal;

import com.gradle.enterprise.gradleplugin.testdistribution.internal.ProcessedResourcesSpec;
import com.gradle.enterprise.gradleplugin.testdistribution.internal.TestDistributionExtensionInternal;
import com.gradle.enterprise.gradleplugin.testdistribution.internal.WorkspaceRootSpec;
import com.gradle.enterprise.gradleplugin.testdistribution.internal.k;
import com.gradle.enterprise.testdistribution.obfuscated.ay.b;
import com.gradle.enterprise.testdistribution.obfuscated.ba.c;
import com.gradle.enterprise.testdistribution.obfuscated.ba.d;
import com.gradle.enterprise.testdistribution.obfuscated.br.am;
import java.io.File;
import java.time.Duration;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.testing.Test;

public abstract class DefaultTestDistributionExtension
implements TestDistributionExtensionInternal {
    private static final String ACCESS_KEYS_PATH_IN_GRADLE_USER_HOME = "enterprise/keys.properties";
    private static final String DEFAULT_TEST_DISTRIBUTION_OUTPUTS_LOCATION = "test-distribution-outputs";
    private final NamedDomainObjectContainer<ProcessedResourcesSpec> processedResources;
    private final NamedDomainObjectContainer<WorkspaceRootSpec> workspaceRoots;

    @Inject
    public DefaultTestDistributionExtension(Test test, ProviderFactory providers) {
        Project project = test.getProject();
        Project rootProject = project.getRootProject();
        ObjectFactory objectFactory = project.getObjects();
        this.getEnabled().convention((Object)false);
        this.getMaxLocalExecutors().convention(providers.provider(() -> ((Test)test).getMaxParallelForks()));
        this.getRemoteExecutionPreferred().convention((Object)false);
        this.getWaitTimeout().convention((Object)Duration.ofSeconds(30L));
        this.processedResources = project.container(ProcessedResourcesSpec.class, (NamedDomainObjectFactory)new a(objectFactory));
        this.getRequirements().empty();
        this.getBuildScanExtension().convention(providers.provider(() -> com.gradle.enterprise.testdistribution.obfuscated.ay.a.a(rootProject)));
        Provider<b> buildScanFacade = this.getBuildScanFacade(providers);
        this.getServer().convention(b.getServer(providers, buildScanFacade));
        this.getAccessKey().convention(b.getAccessKey(providers, buildScanFacade));
        this.getAllowUntrustedServer().convention(b.getAllowUntrusted(providers, buildScanFacade));
        this.getWriteTraceFile().convention(providers.provider(() -> k.b(project)));
        this.getWriteTestEventLogFile().convention(providers.provider(() -> k.c(project)));
        this.getForkedVMShutdownTimeout().convention((Object)am.a);
        Provider testRetry = providers.provider(() -> d.a(test, project));
        this.getMaxRetries().convention(testRetry.flatMap(c::getMaxRetries));
        this.getMaxFailures().convention(testRetry.flatMap(c::getMaxFailures));
        this.getFailOnPassedAfterRetry().convention(testRetry.flatMap(c::getFailOnPassedAfterRetry));
        this.getShowStacktraces().convention((Object)(project.getGradle().getStartParameter().getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS ? 1 : 0));
        this.getRootProjectName().convention((Object)project.getRootProject().getName());
        this.getAllowUseWithoutBuildScans().convention((Object)k.a(project));
        this.getTestDistributionOutputs().convention(project.getLayout().getBuildDirectory().dir("test-distribution-outputs/" + test.getName()));
        this.getRetryInSameJvm().convention((Object)Boolean.TRUE);
        this.workspaceRoots = project.container(WorkspaceRootSpec.class);
        this.workspaceRoots.add((Object)new WorkspaceRootSpec("rootDir", project.getRootDir().toPath()));
        this.workspaceRoots.add((Object)new WorkspaceRootSpec("projectDir", project.getProjectDir().toPath()));
        File gradleHomeDir = project.getGradle().getGradleHomeDir();
        if (gradleHomeDir != null) {
            this.workspaceRoots.add((Object)new WorkspaceRootSpec("gradleHome", gradleHomeDir.toPath()));
        }
        File gradleUserHomeDir = project.getGradle().getGradleUserHomeDir();
        this.workspaceRoots.add((Object)new WorkspaceRootSpec("gradleUserHome", gradleUserHomeDir.toPath()));
        this.getAccessKeyLocation().convention(project.getLayout().file(providers.provider(() -> new File(gradleUserHomeDir, ACCESS_KEYS_PATH_IN_GRADLE_USER_HOME))));
    }

    @Override
    public NamedDomainObjectContainer<ProcessedResourcesSpec> getProcessedResources() {
        return this.processedResources;
    }

    @Override
    public void processedResources(Action<? super NamedDomainObjectContainer<ProcessedResourcesSpec>> action) {
        action.execute(this.processedResources);
    }

    @Override
    public NamedDomainObjectContainer<WorkspaceRootSpec> getWorkspaceRoots() {
        return this.workspaceRoots;
    }

    public boolean shouldTestRetryPluginBeDeactivated() {
        this.getDeactivateRetryPlugin().finalizeValue();
        return (Boolean)this.getDeactivateRetryPlugin().get();
    }

    private static class a
    implements NamedDomainObjectFactory<ProcessedResourcesSpec> {
        private final ObjectFactory a;

        @Inject
        public a(ObjectFactory objectFactory) {
            this.a = objectFactory;
        }

        public ProcessedResourcesSpec a(String name) {
            return (ProcessedResourcesSpec)this.a.newInstance(ProcessedResourcesSpec.class, new Object[]{name, this.a});
        }

        public /* synthetic */ Object create(String string) {
            return this.a(string);
        }
    }
}

