/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.unix.freebsd;

import com.gradle.scan.plugin.internal.dep.oshi.hardware.VirtualMemory;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.common.AbstractGlobalMemory;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.unix.freebsd.FreeBsdVirtualMemory;
import com.gradle.scan.plugin.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.scan.plugin.internal.dep.oshi.util.Memoizer;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.platform.unix.freebsd.BsdSysctlUtil;
import java.util.function.Supplier;

final class FreeBsdGlobalMemory
extends AbstractGlobalMemory {
    private final Supplier<Long> available = Memoizer.memoize(this::queryVmStats, Memoizer.defaultExpiration());
    private final Supplier<Long> total = Memoizer.memoize(FreeBsdGlobalMemory::queryPhysMem);
    private final Supplier<Long> pageSize = Memoizer.memoize(FreeBsdGlobalMemory::queryPageSize);
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(this::createVirtualMemory);

    FreeBsdGlobalMemory() {
    }

    @Override
    public long getAvailable() {
        return this.available.get();
    }

    @Override
    public long getTotal() {
        return this.total.get();
    }

    public long getPageSize() {
        return this.pageSize.get();
    }

    private long queryVmStats() {
        int n2 = BsdSysctlUtil.sysctl("vm.stats.vm.v_inactive_count", 0);
        int n3 = BsdSysctlUtil.sysctl("vm.stats.vm.v_free_count", 0);
        return (long)(n2 + n3) * this.getPageSize();
    }

    private static long queryPhysMem() {
        return BsdSysctlUtil.sysctl("hw.physmem", 0L);
    }

    private static long queryPageSize() {
        return ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("sysconf PAGESIZE"), 4096L);
    }

    private VirtualMemory createVirtualMemory() {
        return new FreeBsdVirtualMemory(this);
    }
}

