/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.ByteVector;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.Edge;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.Frame;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.MethodVisitor;

public class Label {
    static final Label EMPTY_LIST = new Label();
    short flags;
    private short lineNumber;
    private int[] otherLineNumbers;
    int bytecodeOffset;
    private int[] forwardReferences;
    short inputStackSize;
    short outputStackSize;
    short outputStackMax;
    short subroutineId;
    Frame frame;
    Label nextBasicBlock;
    Edge outgoingEdges;
    Label nextListElement;

    final Label getCanonicalInstance() {
        return this.frame == null ? this : this.frame.owner;
    }

    final void addLineNumber(int n2) {
        if ((this.flags & 0x80) == 0) {
            this.flags = (short)(this.flags | 0x80);
            this.lineNumber = (short)n2;
        } else {
            int n3;
            if (this.otherLineNumbers == null) {
                this.otherLineNumbers = new int[4];
            }
            if ((n3 = (this.otherLineNumbers[0] = this.otherLineNumbers[0] + 1)) >= this.otherLineNumbers.length) {
                int[] nArray = new int[this.otherLineNumbers.length + 4];
                System.arraycopy(this.otherLineNumbers, 0, nArray, 0, this.otherLineNumbers.length);
                this.otherLineNumbers = nArray;
            }
            this.otherLineNumbers[n3] = n2;
        }
    }

    final void accept(MethodVisitor methodVisitor, boolean bl2) {
        methodVisitor.visitLabel(this);
        if (bl2 && (this.flags & 0x80) != 0) {
            methodVisitor.visitLineNumber(this.lineNumber & 0xFFFF, this);
            if (this.otherLineNumbers != null) {
                for (int i2 = 1; i2 <= this.otherLineNumbers[0]; ++i2) {
                    methodVisitor.visitLineNumber(this.otherLineNumbers[i2], this);
                }
            }
        }
    }

    final void put(ByteVector byteVector, int n2, boolean bl2) {
        if ((this.flags & 4) == 0) {
            if (bl2) {
                this.addForwardReference(n2, 0x20000000, byteVector.length);
                byteVector.putInt(-1);
            } else {
                this.addForwardReference(n2, 0x10000000, byteVector.length);
                byteVector.putShort(-1);
            }
        } else if (bl2) {
            byteVector.putInt(this.bytecodeOffset - n2);
        } else {
            byteVector.putShort(this.bytecodeOffset - n2);
        }
    }

    final void put(ByteVector byteVector) {
        if ((this.flags & 4) == 0) {
            this.addForwardReference(0, 0x30000000, byteVector.length);
        }
        byteVector.putShort(this.bytecodeOffset);
    }

    private void addForwardReference(int n2, int n3, int n4) {
        int n5;
        if (this.forwardReferences == null) {
            this.forwardReferences = new int[6];
        }
        if ((n5 = this.forwardReferences[0]) + 2 >= this.forwardReferences.length) {
            int[] nArray = new int[this.forwardReferences.length + 6];
            System.arraycopy(this.forwardReferences, 0, nArray, 0, this.forwardReferences.length);
            this.forwardReferences = nArray;
        }
        this.forwardReferences[++n5] = n2;
        this.forwardReferences[++n5] = n3 | n4;
        this.forwardReferences[0] = n5;
    }

    final boolean resolve(byte[] byArray, ByteVector byteVector, int n2) {
        this.flags = (short)(this.flags | 4);
        this.bytecodeOffset = n2;
        if (this.forwardReferences == null) {
            return false;
        }
        boolean bl2 = false;
        for (int i2 = this.forwardReferences[0]; i2 > 0; i2 -= 2) {
            int n3 = this.forwardReferences[i2 - 1];
            int n4 = this.forwardReferences[i2];
            int n5 = n2 - n3;
            int n6 = n4 & 0xFFFFFFF;
            if ((n4 & 0xF0000000) == 0x10000000) {
                if (n5 < Short.MIN_VALUE || n5 > Short.MAX_VALUE) {
                    int n7 = byArray[n3] & 0xFF;
                    byArray[n3] = n7 < 198 ? (byte)(n7 + 49) : (byte)(n7 + 20);
                    bl2 = true;
                }
                byArray[n6++] = (byte)(n5 >>> 8);
                byArray[n6] = (byte)n5;
                continue;
            }
            if ((n4 & 0xF0000000) == 0x20000000) {
                byArray[n6++] = (byte)(n5 >>> 24);
                byArray[n6++] = (byte)(n5 >>> 16);
                byArray[n6++] = (byte)(n5 >>> 8);
                byArray[n6] = (byte)n5;
                continue;
            }
            byteVector.data[n6++] = (byte)(n2 >>> 8);
            byteVector.data[n6] = (byte)n2;
        }
        return bl2;
    }

    final void markSubroutine(short s2) {
        Label label = this;
        label.nextListElement = EMPTY_LIST;
        while (label != EMPTY_LIST) {
            Label label2 = label;
            label = label.nextListElement;
            label2.nextListElement = null;
            if (label2.subroutineId != 0) continue;
            label2.subroutineId = s2;
            label = label2.pushSuccessors(label);
        }
    }

    final void addSubroutineRetSuccessors(Label label) {
        Label label2;
        Label label3 = EMPTY_LIST;
        Label label4 = this;
        label4.nextListElement = EMPTY_LIST;
        while (label4 != EMPTY_LIST) {
            label2 = label4;
            label4 = label2.nextListElement;
            label2.nextListElement = label3;
            label3 = label2;
            if ((label2.flags & 0x40) != 0 && label2.subroutineId != label.subroutineId) {
                label2.outgoingEdges = new Edge(label2.outputStackSize, label.outgoingEdges.successor, label2.outgoingEdges);
            }
            label4 = label2.pushSuccessors(label4);
        }
        while (label3 != EMPTY_LIST) {
            label2 = label3.nextListElement;
            label3.nextListElement = null;
            label3 = label2;
        }
    }

    private Label pushSuccessors(Label label) {
        Label label2 = label;
        Edge edge = this.outgoingEdges;
        while (edge != null) {
            boolean bl2;
            boolean bl3 = bl2 = (this.flags & 0x10) != 0 && edge == this.outgoingEdges.nextEdge;
            if (!bl2 && edge.successor.nextListElement == null) {
                edge.successor.nextListElement = label2;
                label2 = edge.successor;
            }
            edge = edge.nextEdge;
        }
        return label2;
    }

    public String toString() {
        return Label.stringConcat$0(System.identityHashCode(this));
    }

    private static /* synthetic */ String stringConcat$0(int n2) {
        return "L" + n2;
    }
}

