/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.software.os.mac;

import com.gradle.scan.plugin.internal.dep.oshi.software.common.AbstractOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.ApplicationInfo;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.mac.MacInstalledApps;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.mac.MacOperatingSystemJNA;
import com.gradle.scan.plugin.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.scan.plugin.internal.dep.oshi.util.FileUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.Memoizer;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.Util;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MacOperatingSystem
extends AbstractOperatingSystem {
    private static final Logger LOG = LoggerFactory.getLogger(MacOperatingSystemJNA.class);
    protected final int maxProc;
    protected final String osXVersion;
    protected final int major;
    protected final int minor;
    private final Supplier<List<ApplicationInfo>> installedAppsSupplier = Memoizer.memoize(MacInstalledApps::queryInstalledApps, Memoizer.installedAppsExpiration());

    protected MacOperatingSystem(int n2) {
        String string = System.getProperty("os.version");
        int n3 = ParseUtil.getFirstIntValue(string);
        int n4 = ParseUtil.getNthIntValue(string, 2);
        if (n3 == 10 && n4 > 15) {
            String string2 = ExecutingCommand.getFirstAnswer("sw_vers -productVersion");
            if (!string2.isEmpty()) {
                string = string2;
            }
            n3 = ParseUtil.getFirstIntValue(string);
            n4 = ParseUtil.getNthIntValue(string, 2);
        }
        this.osXVersion = string;
        this.major = n3;
        this.minor = n4;
        this.maxProc = n2;
    }

    @Override
    public String queryManufacturer() {
        return "Apple";
    }

    protected String parseCodeName() {
        Properties properties = FileUtil.readPropertiesFromFilename("oshi.macos.versions.properties");
        String string = null;
        if (this.major > 10) {
            string = properties.getProperty(Integer.toString(this.major));
        } else if (this.major == 10) {
            string = properties.getProperty(this.major + "." + this.minor);
        }
        if (Util.isBlank(string)) {
            LOG.warn("Unable to parse version {}.{} to a codename.", (Object)this.major, (Object)this.minor);
        }
        return string;
    }

    @Override
    protected int queryBitness(int n2) {
        if (n2 == 64 || this.major == 10 && this.minor > 6) {
            return 64;
        }
        return ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer("getconf LONG_BIT"), 32);
    }
}

