/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util.internal;

import com.gradle.scan.plugin.internal.dep.io.netty.util.IllegalReferenceCountException;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public final class RefCnt {
    private static final int REF_CNT_IMPL = PlatformDependent.hasUnsafe() ? 0 : (PlatformDependent.hasVarHandle() ? 1 : 2);
    volatile int value;

    public RefCnt() {
        switch (REF_CNT_IMPL) {
            case 0: {
                UnsafeRefCnt.init(this);
                break;
            }
            case 1: {
                VarHandleRefCnt.init(this);
                break;
            }
            default: {
                AtomicRefCnt.init(this);
            }
        }
    }

    public static int refCnt(RefCnt refCnt) {
        switch (REF_CNT_IMPL) {
            case 0: {
                return UnsafeRefCnt.refCnt(refCnt);
            }
            case 1: {
                return VarHandleRefCnt.refCnt(refCnt);
            }
        }
        return AtomicRefCnt.refCnt(refCnt);
    }

    public static void retain(RefCnt refCnt) {
        switch (REF_CNT_IMPL) {
            case 0: {
                UnsafeRefCnt.retain(refCnt);
                break;
            }
            case 1: {
                VarHandleRefCnt.retain(refCnt);
                break;
            }
            default: {
                AtomicRefCnt.retain(refCnt);
            }
        }
    }

    public static boolean release(RefCnt refCnt) {
        switch (REF_CNT_IMPL) {
            case 0: {
                return UnsafeRefCnt.release(refCnt);
            }
            case 1: {
                return VarHandleRefCnt.release(refCnt);
            }
        }
        return AtomicRefCnt.release(refCnt);
    }

    public static boolean release(RefCnt refCnt, int n2) {
        switch (REF_CNT_IMPL) {
            case 0: {
                return UnsafeRefCnt.release(refCnt, n2);
            }
            case 1: {
                return VarHandleRefCnt.release(refCnt, n2);
            }
        }
        return AtomicRefCnt.release(refCnt, n2);
    }

    public static boolean isLiveNonVolatile(RefCnt refCnt) {
        switch (REF_CNT_IMPL) {
            case 0: {
                return UnsafeRefCnt.isLiveNonVolatile(refCnt);
            }
            case 1: {
                return VarHandleRefCnt.isLiveNonVolatile(refCnt);
            }
        }
        return AtomicRefCnt.isLiveNonVolatile(refCnt);
    }

    public static void resetRefCnt(RefCnt refCnt) {
        switch (REF_CNT_IMPL) {
            case 0: {
                UnsafeRefCnt.resetRefCnt(refCnt);
                break;
            }
            case 1: {
                VarHandleRefCnt.resetRefCnt(refCnt);
                break;
            }
            default: {
                AtomicRefCnt.resetRefCnt(refCnt);
            }
        }
    }

    static void throwIllegalRefCountOnRelease(int n2, int n3) {
        throw new IllegalReferenceCountException(n3 >>> 1, -(n2 >>> 1));
    }

    private static final class UnsafeRefCnt {
        private static final long VALUE_OFFSET = UnsafeRefCnt.getUnsafeOffset(RefCnt.class, "value");

        private static long getUnsafeOffset(Class<?> clazz, String string) {
            try {
                if (PlatformDependent.hasUnsafe()) {
                    return PlatformDependent.objectFieldOffset(clazz.getDeclaredField(string));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return -1L;
        }

        static void init(RefCnt refCnt) {
            PlatformDependent.safeConstructPutInt(refCnt, VALUE_OFFSET, 2);
        }

        static int refCnt(RefCnt refCnt) {
            return PlatformDependent.getVolatileInt(refCnt, VALUE_OFFSET) >>> 1;
        }

        static void retain(RefCnt refCnt) {
            UnsafeRefCnt.retain0(refCnt, 2);
        }

        private static void retain0(RefCnt refCnt, int n2) {
            int n3 = PlatformDependent.getAndAddInt(refCnt, VALUE_OFFSET, n2);
            if ((n3 & 0x80000001) != 0 || n3 > Integer.MAX_VALUE - n2) {
                PlatformDependent.getAndAddInt(refCnt, VALUE_OFFSET, -n2);
                throw new IllegalReferenceCountException(0, n2 >>> 1);
            }
        }

        static boolean release(RefCnt refCnt) {
            return UnsafeRefCnt.release0(refCnt, 2);
        }

        static boolean release(RefCnt refCnt, int n2) {
            return UnsafeRefCnt.release0(refCnt, ObjectUtil.checkPositive(n2, "decrement") << 1);
        }

        private static boolean release0(RefCnt refCnt, int n2) {
            int n3;
            int n4;
            do {
                if ((n4 = PlatformDependent.getInt(refCnt, VALUE_OFFSET)) == n2) {
                    n3 = 1;
                    continue;
                }
                if (n4 < n2 || (n4 & 1) == 1) {
                    RefCnt.throwIllegalRefCountOnRelease(n2, n4);
                }
                n3 = n4 - n2;
            } while (!PlatformDependent.compareAndSwapInt(refCnt, VALUE_OFFSET, n4, n3));
            return (n3 & 1) == 1;
        }

        static void resetRefCnt(RefCnt refCnt) {
            PlatformDependent.putOrderedInt(refCnt, VALUE_OFFSET, 2);
        }

        static boolean isLiveNonVolatile(RefCnt refCnt) {
            int n2 = PlatformDependent.getInt(refCnt, VALUE_OFFSET);
            if (n2 == 2) {
                return true;
            }
            return (n2 & 1) == 0;
        }
    }

    private static final class VarHandleRefCnt {
        private static final VarHandle VH = PlatformDependent.findVarHandleOfIntField(MethodHandles.lookup(), RefCnt.class, "value");

        static void init(RefCnt refCnt) {
            VH.set(refCnt, 2);
            VarHandle.storeStoreFence();
        }

        static int refCnt(RefCnt refCnt) {
            return VH.getAcquire(refCnt) >>> 1;
        }

        static void retain(RefCnt refCnt) {
            VarHandleRefCnt.retain0(refCnt, 2);
        }

        private static void retain0(RefCnt refCnt, int n2) {
            int n3 = VH.getAndAdd(refCnt, n2);
            if ((n3 & 0x80000001) != 0 || n3 > Integer.MAX_VALUE - n2) {
                VH.getAndAdd(refCnt, -n2);
                throw new IllegalReferenceCountException(0, n2 >>> 1);
            }
        }

        static boolean release(RefCnt refCnt) {
            return VarHandleRefCnt.release0(refCnt, 2);
        }

        static boolean release(RefCnt refCnt, int n2) {
            return VarHandleRefCnt.release0(refCnt, ObjectUtil.checkPositive(n2, "decrement") << 1);
        }

        private static boolean release0(RefCnt refCnt, int n2) {
            int n3;
            int n4;
            do {
                if ((n4 = VH.get(refCnt)) == n2) {
                    n3 = 1;
                    continue;
                }
                if (n4 < n2 || (n4 & 1) == 1) {
                    RefCnt.throwIllegalRefCountOnRelease(n2, n4);
                }
                n3 = n4 - n2;
            } while (!VH.compareAndSet(refCnt, n4, n3));
            return (n3 & 1) == 1;
        }

        static void resetRefCnt(RefCnt refCnt) {
            VH.setRelease(refCnt, 2);
        }

        static boolean isLiveNonVolatile(RefCnt refCnt) {
            int n2 = VH.get(refCnt);
            if (n2 == 2) {
                return true;
            }
            return (n2 & 1) == 0;
        }
    }

    private static final class AtomicRefCnt {
        private static final AtomicIntegerFieldUpdater<RefCnt> UPDATER = AtomicIntegerFieldUpdater.newUpdater(RefCnt.class, "value");

        static void init(RefCnt refCnt) {
            UPDATER.set(refCnt, 2);
        }

        static int refCnt(RefCnt refCnt) {
            return UPDATER.get(refCnt) >>> 1;
        }

        static void retain(RefCnt refCnt) {
            AtomicRefCnt.retain0(refCnt, 2);
        }

        private static void retain0(RefCnt refCnt, int n2) {
            int n3 = UPDATER.getAndAdd(refCnt, n2);
            if ((n3 & 0x80000001) != 0 || n3 > Integer.MAX_VALUE - n2) {
                UPDATER.getAndAdd(refCnt, -n2);
                throw new IllegalReferenceCountException(0, n2 >>> 1);
            }
        }

        static boolean release(RefCnt refCnt) {
            return AtomicRefCnt.release0(refCnt, 2);
        }

        static boolean release(RefCnt refCnt, int n2) {
            return AtomicRefCnt.release0(refCnt, ObjectUtil.checkPositive(n2, "decrement") << 1);
        }

        private static boolean release0(RefCnt refCnt, int n2) {
            int n3;
            int n4;
            do {
                if ((n4 = refCnt.value) == n2) {
                    n3 = 1;
                    continue;
                }
                if (n4 < n2 || (n4 & 1) == 1) {
                    RefCnt.throwIllegalRefCountOnRelease(n2, n4);
                }
                n3 = n4 - n2;
            } while (!UPDATER.compareAndSet(refCnt, n4, n3));
            return (n3 & 1) == 1;
        }

        static void resetRefCnt(RefCnt refCnt) {
            UPDATER.lazySet(refCnt, 2);
        }

        static boolean isLiveNonVolatile(RefCnt refCnt) {
            int n2 = refCnt.value;
            if (n2 == 2) {
                return true;
            }
            return (n2 & 1) == 0;
        }
    }
}

