/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent;

import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.AbstractEventExecutor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.EventExecutorGroup;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.ScheduledFuture;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.ScheduledFutureTask;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.Ticker;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.DefaultPriorityQueue;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PriorityQueue;
import java.util.Comparator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public abstract class AbstractScheduledEventExecutor
extends AbstractEventExecutor {
    private static final Comparator<ScheduledFutureTask<?>> SCHEDULED_FUTURE_TASK_COMPARATOR = new Comparator<ScheduledFutureTask<?>>(){

        @Override
        public int compare(ScheduledFutureTask<?> scheduledFutureTask, ScheduledFutureTask<?> scheduledFutureTask2) {
            return scheduledFutureTask.compareTo(scheduledFutureTask2);
        }
    };
    static final Runnable WAKEUP_TASK = new Runnable(){

        @Override
        public void run() {
        }
    };
    PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue;
    long nextTaskId;

    protected AbstractScheduledEventExecutor() {
    }

    protected AbstractScheduledEventExecutor(EventExecutorGroup eventExecutorGroup) {
        super(eventExecutorGroup);
    }

    public Ticker ticker() {
        return Ticker.systemTicker();
    }

    @Deprecated
    protected long getCurrentTimeNanos() {
        return this.ticker().nanoTime();
    }

    static long deadlineNanos(long l2, long l3) {
        long l4 = l2 + l3;
        return l4 < 0L ? Long.MAX_VALUE : l4;
    }

    PriorityQueue<ScheduledFutureTask<?>> scheduledTaskQueue() {
        if (this.scheduledTaskQueue == null) {
            this.scheduledTaskQueue = new DefaultPriorityQueue(SCHEDULED_FUTURE_TASK_COMPARATOR, 11);
        }
        return this.scheduledTaskQueue;
    }

    private static boolean isNullOrEmpty(Queue<ScheduledFutureTask<?>> queue) {
        return queue == null || queue.isEmpty();
    }

    protected void cancelScheduledTasks() {
        ScheduledFutureTask[] scheduledFutureTaskArray;
        assert (this.inEventLoop());
        PriorityQueue<ScheduledFutureTask<?>> priorityQueue = this.scheduledTaskQueue;
        if (AbstractScheduledEventExecutor.isNullOrEmpty(priorityQueue)) {
            return;
        }
        for (ScheduledFutureTask scheduledFutureTask : scheduledFutureTaskArray = priorityQueue.toArray(new ScheduledFutureTask[0])) {
            scheduledFutureTask.cancelWithoutRemove(false);
        }
        priorityQueue.clearIgnoringIndexes();
    }

    protected boolean fetchFromScheduledTaskQueue(Queue<Runnable> queue) {
        ScheduledFutureTask scheduledFutureTask;
        assert (this.inEventLoop());
        Objects.requireNonNull(queue, "taskQueue");
        if (this.scheduledTaskQueue == null || this.scheduledTaskQueue.isEmpty()) {
            return true;
        }
        long l2 = this.getCurrentTimeNanos();
        do {
            if ((scheduledFutureTask = (ScheduledFutureTask)this.pollScheduledTask(l2)) != null) continue;
            return true;
        } while (scheduledFutureTask.isCancelled() || queue.offer(scheduledFutureTask));
        this.scheduledTaskQueue.add(scheduledFutureTask);
        return false;
    }

    protected final Runnable pollScheduledTask(long l2) {
        assert (this.inEventLoop());
        ScheduledFutureTask<?> scheduledFutureTask = this.peekScheduledTask();
        if (scheduledFutureTask == null || scheduledFutureTask.deadlineNanos() - l2 > 0L) {
            return null;
        }
        this.scheduledTaskQueue.remove();
        scheduledFutureTask.setConsumed();
        return scheduledFutureTask;
    }

    protected final long nextScheduledTaskNano() {
        ScheduledFutureTask<?> scheduledFutureTask = this.peekScheduledTask();
        return scheduledFutureTask != null ? scheduledFutureTask.delayNanos() : -1L;
    }

    protected final long nextScheduledTaskDeadlineNanos() {
        ScheduledFutureTask<?> scheduledFutureTask = this.peekScheduledTask();
        return scheduledFutureTask != null ? scheduledFutureTask.deadlineNanos() : -1L;
    }

    final ScheduledFutureTask<?> peekScheduledTask() {
        PriorityQueue<ScheduledFutureTask<?>> priorityQueue = this.scheduledTaskQueue;
        return priorityQueue != null ? (ScheduledFutureTask)priorityQueue.peek() : null;
    }

    protected final boolean hasScheduledTasks() {
        ScheduledFutureTask<?> scheduledFutureTask = this.peekScheduledTask();
        return scheduledFutureTask != null && scheduledFutureTask.deadlineNanos() <= this.getCurrentTimeNanos();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l2, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l2 < 0L) {
            l2 = 0L;
        }
        this.validateScheduled0(l2, timeUnit);
        return this.schedule(new ScheduledFutureTask(this, runnable, AbstractScheduledEventExecutor.deadlineNanos(this.getCurrentTimeNanos(), timeUnit.toNanos(l2))));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l2, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(callable, "callable");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l2 < 0L) {
            l2 = 0L;
        }
        this.validateScheduled0(l2, timeUnit);
        return this.schedule(new ScheduledFutureTask<V>(this, callable, AbstractScheduledEventExecutor.deadlineNanos(this.getCurrentTimeNanos(), timeUnit.toNanos(l2))));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l2 < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", l2));
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException(String.format("period: %d (expected: > 0)", l3));
        }
        this.validateScheduled0(l2, timeUnit);
        this.validateScheduled0(l3, timeUnit);
        return this.schedule(new ScheduledFutureTask(this, runnable, AbstractScheduledEventExecutor.deadlineNanos(this.getCurrentTimeNanos(), timeUnit.toNanos(l2)), timeUnit.toNanos(l3)));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l2 < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", l2));
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: > 0)", l3));
        }
        this.validateScheduled0(l2, timeUnit);
        this.validateScheduled0(l3, timeUnit);
        return this.schedule(new ScheduledFutureTask(this, runnable, AbstractScheduledEventExecutor.deadlineNanos(this.getCurrentTimeNanos(), timeUnit.toNanos(l2)), -timeUnit.toNanos(l3)));
    }

    private void validateScheduled0(long l2, TimeUnit timeUnit) {
        this.validateScheduled(l2, timeUnit);
    }

    @Deprecated
    protected void validateScheduled(long l2, TimeUnit timeUnit) {
    }

    final void scheduleFromEventLoop(ScheduledFutureTask<?> scheduledFutureTask) {
        if (scheduledFutureTask.getId() == 0L) {
            scheduledFutureTask.setId(++this.nextTaskId);
        }
        this.scheduledTaskQueue().add(scheduledFutureTask);
    }

    private <V> ScheduledFuture<V> schedule(ScheduledFutureTask<V> scheduledFutureTask) {
        if (this.inEventLoop()) {
            this.scheduleFromEventLoop(scheduledFutureTask);
        } else {
            long l2 = scheduledFutureTask.deadlineNanos();
            if (this.beforeScheduledTaskSubmitted(l2)) {
                this.execute(scheduledFutureTask);
            } else {
                this.lazyExecute(scheduledFutureTask);
                if (this.afterScheduledTaskSubmitted(l2)) {
                    this.execute(WAKEUP_TASK);
                }
            }
        }
        return scheduledFutureTask;
    }

    final void removeScheduled(ScheduledFutureTask<?> scheduledFutureTask) {
        assert (scheduledFutureTask.isCancelled());
        if (this.inEventLoop()) {
            this.scheduledTaskQueue().removeTyped(scheduledFutureTask);
        } else {
            this.scheduleRemoveScheduled(scheduledFutureTask);
        }
    }

    void scheduleRemoveScheduled(ScheduledFutureTask<?> scheduledFutureTask) {
        this.lazyExecute(scheduledFutureTask);
    }

    protected boolean beforeScheduledTaskSubmitted(long l2) {
        return true;
    }

    protected boolean afterScheduledTaskSubmitted(long l2) {
        return true;
    }
}

