/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.AbstractByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.EmptyByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ReadOnlyAbstractByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ReadOnlyByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ReadOnlyByteBufferBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ReadOnlyUnsafeDirectByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.UnpooledByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.UnpooledDirectByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.UnpooledHeapByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.UnreleasableByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.util.CharsetUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public final class Unpooled {
    private static final ByteBufAllocator ALLOC = UnpooledByteBufAllocator.DEFAULT;
    public static final ByteOrder BIG_ENDIAN = ByteOrder.BIG_ENDIAN;
    public static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
    public static final ByteBuf EMPTY_BUFFER = ALLOC.buffer(0, 0);

    public static ByteBuf buffer(int n2) {
        return ALLOC.heapBuffer(n2);
    }

    public static ByteBuf directBuffer(int n2) {
        return ALLOC.directBuffer(n2);
    }

    public static ByteBuf directBuffer(int n2, int n3) {
        return ALLOC.directBuffer(n2, n3);
    }

    public static ByteBuf wrappedBuffer(byte[] byArray) {
        if (byArray.length == 0) {
            return EMPTY_BUFFER;
        }
        return new UnpooledHeapByteBuf(ALLOC, byArray, byArray.length);
    }

    public static ByteBuf wrappedBuffer(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return EMPTY_BUFFER;
        }
        if (n2 == 0 && n3 == byArray.length) {
            return Unpooled.wrappedBuffer(byArray);
        }
        return Unpooled.wrappedBuffer(byArray).slice(n2, n3);
    }

    public static ByteBuf wrappedBuffer(ByteBuffer byteBuffer) {
        if (!byteBuffer.hasRemaining()) {
            return EMPTY_BUFFER;
        }
        if (!byteBuffer.isDirect() && byteBuffer.hasArray()) {
            return Unpooled.wrappedBuffer(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining()).order(byteBuffer.order());
        }
        if (PlatformDependent.hasUnsafe()) {
            if (byteBuffer.isReadOnly()) {
                if (byteBuffer.isDirect()) {
                    return new ReadOnlyUnsafeDirectByteBuf(ALLOC, byteBuffer);
                }
                return new ReadOnlyByteBufferBuf(ALLOC, byteBuffer);
            }
            return new UnpooledUnsafeDirectByteBuf(ALLOC, byteBuffer, byteBuffer.remaining());
        }
        if (byteBuffer.isReadOnly()) {
            return new ReadOnlyByteBufferBuf(ALLOC, byteBuffer);
        }
        return new UnpooledDirectByteBuf(ALLOC, byteBuffer, byteBuffer.remaining());
    }

    public static ByteBuf copiedBuffer(CharSequence charSequence, Charset charset) {
        ObjectUtil.checkNotNull(charSequence, "string");
        if (CharsetUtil.UTF_8.equals(charset)) {
            return Unpooled.copiedBufferUtf8(charSequence);
        }
        if (CharsetUtil.US_ASCII.equals(charset)) {
            return Unpooled.copiedBufferAscii(charSequence);
        }
        if (charSequence instanceof CharBuffer) {
            return Unpooled.copiedBuffer((CharBuffer)charSequence, charset);
        }
        return Unpooled.copiedBuffer(CharBuffer.wrap(charSequence), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuf copiedBufferUtf8(CharSequence charSequence) {
        boolean bl2 = true;
        int n2 = ByteBufUtil.utf8Bytes(charSequence);
        ByteBuf byteBuf = ALLOC.heapBuffer(n2);
        try {
            ByteBufUtil.reserveAndWriteUtf8(byteBuf, charSequence, n2);
            bl2 = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        finally {
            if (bl2) {
                byteBuf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuf copiedBufferAscii(CharSequence charSequence) {
        boolean bl2 = true;
        ByteBuf byteBuf = ALLOC.heapBuffer(charSequence.length());
        try {
            ByteBufUtil.writeAscii(byteBuf, charSequence);
            bl2 = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        finally {
            if (bl2) {
                byteBuf.release();
            }
        }
    }

    private static ByteBuf copiedBuffer(CharBuffer charBuffer, Charset charset) {
        return ByteBufUtil.encodeString0(ALLOC, true, charBuffer, charset, 0);
    }

    @Deprecated
    public static ByteBuf unmodifiableBuffer(ByteBuf byteBuf) {
        ByteOrder byteOrder = byteBuf.order();
        if (byteOrder == BIG_ENDIAN) {
            return Unpooled.newReadyOnlyBuffer(byteBuf);
        }
        return Unpooled.newReadyOnlyBuffer(byteBuf.order(BIG_ENDIAN)).order(LITTLE_ENDIAN);
    }

    private static ReadOnlyByteBuf newReadyOnlyBuffer(ByteBuf byteBuf) {
        return byteBuf instanceof AbstractByteBuf ? new ReadOnlyAbstractByteBuf((AbstractByteBuf)byteBuf) : new ReadOnlyByteBuf(byteBuf);
    }

    public static ByteBuf unreleasableBuffer(ByteBuf byteBuf) {
        return new UnreleasableByteBuf(byteBuf);
    }

    private Unpooled() {
    }

    static {
        assert (EMPTY_BUFFER instanceof EmptyByteBuf) : "EMPTY_BUFFER must be an EmptyByteBuf.";
    }
}

