/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.aix;

import com.gradle.scan.plugin.internal.dep.oshi.driver.unix.aix.PsInfo;
import com.gradle.scan.plugin.internal.dep.oshi.driver.unix.aix.perfstat.PerfstatCpu;
import com.gradle.scan.plugin.internal.dep.oshi.jna.platform.unix.AixLibc;
import com.gradle.scan.plugin.internal.dep.oshi.software.common.AbstractOSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.OSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.aix.AixOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.scan.plugin.internal.dep.oshi.util.Memoizer;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.UserGroupInfo;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Pair;
import com.sun.jna.Native;
import com.sun.jna.platform.unix.aix.Perfstat;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AixOSProcess
extends AbstractOSProcess {
    private static final Logger LOG = LoggerFactory.getLogger(AixOSProcess.class);
    private Supplier<Integer> bitness = Memoizer.memoize(this::queryBitness);
    private Supplier<AixLibc.AixPsInfo> psinfo = Memoizer.memoize(this::queryPsInfo, Memoizer.defaultExpiration());
    private Supplier<String> commandLine = Memoizer.memoize(this::queryCommandLine);
    private Supplier<Pair<List<String>, Map<String, String>>> cmdEnv = Memoizer.memoize(this::queryCommandlineEnvironment);
    private final Supplier<Long> affinityMask = Memoizer.memoize(PerfstatCpu::queryCpuAffinityMask, Memoizer.defaultExpiration());
    private String name;
    private String path = "";
    private String commandLineBackup;
    private String user;
    private String userID;
    private String group;
    private String groupID;
    private OSProcess.State state = OSProcess.State.INVALID;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private Supplier<Perfstat.perfstat_process_t[]> procCpu;
    private final AixOperatingSystem os;

    public AixOSProcess(int n2, Pair<Long, Long> pair, Supplier<Perfstat.perfstat_process_t[]> supplier, AixOperatingSystem aixOperatingSystem) {
        super(n2);
        this.procCpu = supplier;
        this.os = aixOperatingSystem;
        this.updateAttributes(pair);
    }

    private AixLibc.AixPsInfo queryPsInfo() {
        return PsInfo.queryPsInfo(this.getProcessID());
    }

    @Override
    public String getName() {
        return this.name;
    }

    private String queryCommandLine() {
        String string = String.join((CharSequence)" ", this.getArguments());
        return string.isEmpty() ? this.commandLineBackup : string;
    }

    @Override
    public List<String> getArguments() {
        return this.cmdEnv.get().getA();
    }

    private Pair<List<String>, Map<String, String>> queryCommandlineEnvironment() {
        return PsInfo.queryArgsEnv(this.getProcessID(), this.psinfo.get());
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getBitness() {
        return this.bitness.get();
    }

    private int queryBitness() {
        List<String> list = ExecutingCommand.runNative("pflags " + this.getProcessID());
        for (String string : list) {
            if (!string.contains("data model")) continue;
            if (string.contains("LP32")) {
                return 32;
            }
            if (!string.contains("LP64")) continue;
            return 64;
        }
        return 0;
    }

    private boolean updateAttributes(Pair<Long, Long> pair) {
        AixLibc.AixPsInfo aixPsInfo = this.psinfo.get();
        if (aixPsInfo == null) {
            this.state = OSProcess.State.INVALID;
            return false;
        }
        long l2 = System.currentTimeMillis();
        this.state = AixOSProcess.getStateFromOutput((char)aixPsInfo.pr_lwp.pr_sname);
        this.parentProcessID = (int)aixPsInfo.pr_ppid;
        this.userID = Long.toString(aixPsInfo.pr_euid);
        this.user = UserGroupInfo.getUser(this.userID);
        this.groupID = Long.toString(aixPsInfo.pr_egid);
        this.group = UserGroupInfo.getGroupName(this.groupID);
        this.threadCount = aixPsInfo.pr_nlwp;
        this.priority = aixPsInfo.pr_lwp.pr_pri;
        this.virtualSize = aixPsInfo.pr_size * 1024L;
        this.residentSetSize = aixPsInfo.pr_rssize * 1024L;
        this.startTime = aixPsInfo.pr_start.tv_sec * 1000L + (long)aixPsInfo.pr_start.tv_nsec / 1000000L;
        long l3 = l2 - this.startTime;
        this.upTime = l3 < 1L ? 1L : l3;
        this.userTime = pair.getA();
        this.kernelTime = pair.getB();
        this.commandLineBackup = Native.toString(aixPsInfo.pr_psargs);
        this.path = ParseUtil.whitespaces.split(this.commandLineBackup)[0];
        this.name = this.path.substring(this.path.lastIndexOf(47) + 1);
        if (this.name.isEmpty()) {
            this.name = Native.toString(aixPsInfo.pr_fname);
        }
        return true;
    }

    static OSProcess.State getStateFromOutput(char c2) {
        OSProcess.State state;
        switch (c2) {
            case 'O': {
                state = OSProcess.State.INVALID;
                break;
            }
            case 'A': 
            case 'R': {
                state = OSProcess.State.RUNNING;
                break;
            }
            case 'I': {
                state = OSProcess.State.WAITING;
                break;
            }
            case 'S': 
            case 'W': {
                state = OSProcess.State.SLEEPING;
                break;
            }
            case 'Z': {
                state = OSProcess.State.ZOMBIE;
                break;
            }
            case 'T': {
                state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                state = OSProcess.State.OTHER;
            }
        }
        return state;
    }
}

